//////////////////////////////////////////////////////////////////////////////////////////////
/// API_Test.cpp 
/// Description:	This project demonstrates how to use the Chromasens camera-API <BR>
///             	Loading of the library, initialisation and usage of the different functions<BR>
///             	are demonstrated here <BR>
///
/// Author:			Sczech / CHROMASENS GmbH Konstanz <BR>
///
/// Date:			May, 11, 2011
//	Version:		1.0
//////////////////////////////////////////////////////////////////////////////////////////////
// 
//

#include <tchar.h>
#include <iostream>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <Windows.h>

#include "displayHelper.h"
#include "ChromasensApiCalls.h"
#include "../CS_API/ChromasensCameraIf.h"

#pragma comment(lib, "CS_API.lib")

//////////////////////////////////////////////////////////////////////////
/// Constants, global variables, etc.
//////////////////////////////////////////////////////////////////////////


HANDLE con=GetStdHandle(STD_OUTPUT_HANDLE);
const int MAXITEMS = 23;	// Maximum item count of the menu
const INT16 START_MENU = 0;
int nCurrentSetting = -1;

/// Constants for the display of the different menus
const UINT16 START_COMMANDS_MENU = 0;
const UINT16 RAW_COMMANDS_MENU = 1;
const UINT16 COMMAND_MENU1 = 2;
const UINT16 COMMAND_MENU2 = 3;
const UINT16 COMMAND_MENU3 = 4;
const UINT16 COMMAND_MENU4 = 5;
const UINT16 COMMAND_MENU5 = 6;
const UINT16 COMMAND_DEBUG = 7;
CChromasensApiCalls csApiCall;

//////////////////////////////////////////////////////////////////////////////////////////////
/// Helper functions
//////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
// Clear the console
//////////////////////////////////////////////////////////////////////////
void clear() {
	COORD topLeft  = { 0, 0 };
	HANDLE console = GetStdHandle(STD_OUTPUT_HANDLE);
	CONSOLE_SCREEN_BUFFER_INFO screen;
	DWORD written;

	GetConsoleScreenBufferInfo(console, &screen);
	FillConsoleOutputCharacterA(
		console, ' ', screen.dwSize.X * screen.dwSize.Y, topLeft, &written
		);
	FillConsoleOutputAttribute(
		console, FOREGROUND_GREEN | FOREGROUND_RED | FOREGROUND_BLUE,
		screen.dwSize.X * screen.dwSize.Y, topLeft, &written
		);
	SetConsoleCursorPosition(console, topLeft);
}

//////////////////////////////////////////////////////////////////////////
// Sets the current position of the cursor
//////////////////////////////////////////////////////////////////////////
void gotoxy(int x,int y)
{
	COORD Coord;
	Coord.X=x;
	Coord.Y=y;

	SetConsoleCursorPosition(con,Coord);
}

//////////////////////////////////////////////////////////////////////////
// Set the text color
//////////////////////////////////////////////////////////////////////////
void textattr(int color)
{
	SetConsoleTextAttribute(con, color);
}

//////////////////////////////////////////////////////////////////////////
/// Display functions for the different menus
//////////////////////////////////////////////////////////////////////////
INT16 displayMenu(UINT16 menuNo)
{
	const int nYStep = 1; // Vertical space in between the menu items
	string* menu_list=NULL;
	UINT16 maxItems=0;
	char camType[30];

	if(csApiCall.isConnected())
	{
		
		switch(csApiCall.determineCameraType()){
		case ALLPIXA:
			sprintf_s(camType, 30, "allPIXA");
			break;
		case ALLPIXA_PRO:
			sprintf_s(camType, 30, "allPIXA pro");
			break;
		case ALLPIXA_WAVE:
			sprintf_s(camType, 30, "allPIXA wave");
			break;
		default:
			sprintf_s(camType, 30, "allPIXA");
			break;
		}
	}
	else{
		sprintf_s(camType, 30, "Not connected");
	}

	gotoxy(0, 0 );
	textattr(FOREGROUND_GREEN|FOREGROUND_INTENSITY);
	printf("---------------------------------------------------------------\n");
	printf("Chromasens Camera API demonstration program\n");
	printf("---------------------------------------------------------------\n");
	

	printf("Connected: %d   Current Setting: %d   Camera:%s\n", csApiCall.isConnected(), nCurrentSetting, camType);

	int xPos = 2; // Starting x-position for the menu
	int yPos = 5; // Starting y-position for the menu

	INT16 nResult = CS_GENERAL_ERROR;
	switch(menuNo)
	{
	case START_COMMANDS_MENU:
		nResult = CS_OK;
		maxItems = 10;
		menu_list = new string[maxItems];
		menu_list[0] = string("(0) Open Connection");
		menu_list[1] = string("(1) Show raw functions menu");
		menu_list[2] = string("(2) Show command menu 1");
		menu_list[3] = string("(3) Show command menu 2");
		menu_list[4] = string("(4) Show command menu 3");
		menu_list[5] = string("(5) Show command menu 4");
		menu_list[6] = string("(6) Show command menu 5");
		menu_list[7] = string("(7) Show command debug");
		menu_list[8] = string("(8) Auto-detect connected Chromasens cameras");
		menu_list[9] = string("(q) Quit program");
		break;
	case RAW_COMMANDS_MENU:
		nResult = CS_OK;
		maxItems = 14;
		menu_list = new string[maxItems];
		menu_list[0] = string("(0) Get Bin tag");
		menu_list[1] = string("(1) Send BIN tag");
		menu_list[2] = string("(2) Get SHORT tag");
		menu_list[3] = string("(3) Send SHORT tag");
	    menu_list[4] = string("(4) Get LONG tag");
		menu_list[5] = string("(5) Send LONG tag");
		menu_list[6] = string("(6) Get VAR tag");
		menu_list[7] = string("(7) Send VAR tag");
		menu_list[8] = string("(8) Send HSI-file");
		menu_list[9] = string("(9) Send file list (Firmware update)");
		menu_list[10] = string("(a) Get camera register value");
		menu_list[11] = string("(b) Set camera register value");
		menu_list[12] = string("(m) Main menu");
		menu_list[13] = string("(q) Quit program");
		nResult = CS_OK;
		break;
	case COMMAND_MENU1:
		nResult = CS_OK;
		maxItems = 14;
		menu_list = new string[maxItems];
		menu_list[0] = string("(0) Select Setting");
		menu_list[1] = string("(1) Show available settings");
		menu_list[2] = string("(2) Burn Settings to camera");
		menu_list[3] = string("(3) Save current setting to disk");
		menu_list[4] = string("(4) Get setting description");
		menu_list[5] = string("(5) Set setting description");
		menu_list[6] = string("(6) Reset camera");
		menu_list[7] = string("(7) Get reference settings");
		menu_list[8] = string("(8) Set reference settings");
		menu_list[9] = string("(9) Prepare camera for reference");
		menu_list[10] = string("(a) Calculate reference (shading/Offset)");
		menu_list[11] = string("(b) Create reference internally (shading/Offset)");
		menu_list[12] = string("(m) Main menu");
		menu_list[13] = string("(q) Quit program");
		break;
	case COMMAND_MENU2:
		{
			nResult = CS_OK;
			maxItems = 14;
			menu_list = new string[maxItems];
			if(csApiCall.determineCameraType() != ALLPIXA_WAVE)
			{
				menu_list[0] = string("(0) get gain values");
				menu_list[1] = string("(1) set gain values");
				menu_list[2] = string("(2) get initial gain values");
				menu_list[3] = string("(3) set initial gain values");
				menu_list[4] = string("(4) get analog coarse gain");
				menu_list[5] = string("(5) set analog coarse gain");
				menu_list[6] = string("(6) get current white reference values");
				menu_list[7] = string("(7) get white balancing setup");
				menu_list[8] = string("(8) set white balancing setup");
				menu_list[9] = string("(9) Do white balancing");
				menu_list[10] = string("(a) Do tab balancing");
				menu_list[11] = string("(b) Get camera state");
				menu_list[12] = string("(m) Main menu");
				menu_list[13] = string("(q) Quit program");
			}
			else
			{
				menu_list[0] = string("(0) get linear gain values");
				menu_list[1] = string("(1) set linear gain values");
				menu_list[2] = string("(2) get sensor sensitivity values");
				menu_list[3] = string("(3) set sensor sensitivity values");
				menu_list[4] = string("(4) get current white reference values");
				menu_list[5] = string("(5) get white balancing setup");
				menu_list[6] = string("(6) set white balancing setup");
				menu_list[7] = string("(7) Do white balancing");
				menu_list[8] = string("(8) Get camera state");
				menu_list[9] = string("(m) Main menu");
				menu_list[10] = string("(q) Quit program");
				maxItems = 11;
			}
		}
		break;
	case COMMAND_MENU3:
		nResult = CS_OK;
		maxItems = 12;
		menu_list = new string[maxItems];
		if(csApiCall.determineCameraType() != ALLPIXA_WAVE)
		{
			menu_list[0] = string("(0) get image parameters");
			menu_list[1] = string("(1) set image parameters");
		}
		else
		{
			menu_list[0] = string("(0) get roi parameters");
			menu_list[1] = string("(1) set roi parameters");
		}
		menu_list[2] = string("(2) get integration time settings");
		menu_list[3] = string("(3) set integration time settings");
		menu_list[4] = string("(4) get CamLink properties");
		menu_list[5] = string("(5) set CamLink properties");
		menu_list[6] = string("(6) get brightness and contrast settings");
		menu_list[7] = string("(7) set brightness and contrast settings");
		menu_list[8] = string("(8) get image processing parameters");
		menu_list[9] = string("(9) set image processing parameters");
		menu_list[10] = string("(m) Main menu");
		menu_list[11] = string("(q) Quit program");
		break;
	case COMMAND_MENU4:
		nResult = CS_OK;
		maxItems = 14;
		menu_list = new string[maxItems];
		menu_list[0] = string("(0) get physical setup parameters");
		menu_list[1] = string("(1) set physical setup parameters");
		menu_list[2] = string("(2) get video output parameters");
		menu_list[3] = string("(3) set video output parameters");
		menu_list[4] = string("(4) get trigger parameters");
		menu_list[5] = string("(5) set trigger parameters");
		menu_list[6] = string("(6) get encoder parameters");
		menu_list[7] = string("(7) set encoder parameters");
		menu_list[8] = string("(8) get IO configuration");
		menu_list[9] = string("(9) set IO configuration");
		menu_list[10] = string("(a) get camera operating values");
		menu_list[11] = string("(b) get camera information");
		menu_list[12] = string("(m) Main menu");
		menu_list[13] = string("(q) Quit program");
		break;
	case COMMAND_MENU5:
		nResult = CS_OK;
		maxItems = 7;
		menu_list = new string[maxItems];
		menu_list[0] = string("(0) get led flash settings");
		menu_list[1] = string("(1) set led flash settings");
		menu_list[2] = string("(2) get data from camera flash memory");
		menu_list[3] = string("(3) send data to camera flash memory");
		menu_list[3] = string("(4) get image data from camera");
		menu_list[4] = string("(m) Main menu");
		menu_list[5] = string("(q) Quit program");
		break;
	case COMMAND_DEBUG:
		nResult = CS_OK;
		maxItems = 9;
		menu_list = new string[maxItems];
		menu_list[0] = string("(0) Get test pattern setting");
		menu_list[1] = string("(1) Set test pattern setting");
		menu_list[2] = string("(2) Get logging parameter");
		menu_list[3] = string("(3) Set logging parameter");
		menu_list[4] = string("(4) Get trace mode");
		menu_list[5] = string("(5) Set trace mode");
		menu_list[6] = string("(6) Get camera trace messages");
		menu_list[7] = string("(m) Main menu");
		menu_list[8] = string("(q) Quit program");
		break;
	default:
		break;
	}

	// Create the menu on the console screen
	for (int i=0; i< maxItems; ++i)
	{
		gotoxy(xPos, yPos + i*nYStep );
		// In the start up menu the entries for moving to the next menus should only be enabled when a connection to the camera was enabled
		// In the other menus the entries switch back to the start menu and to exit the program should always be available
		if(((menuNo > START_COMMANDS_MENU) 
			&& (!csApiCall.isConnected() && (i < (maxItems -2) )))
			|| ((menuNo == START_COMMANDS_MENU) && !csApiCall.isConnected() && (i < (maxItems -2) && (i > 0) )))
			textattr(DISABLED);
		else
			textattr(ENABLED);
		printf("%s",menu_list[i].c_str() );
	}

	// Free memory again
	if(menu_list)
	{
		delete[] menu_list;
		menu_list = NULL;
	}
	return nResult;
}

//////////////////////////////////////////////////////////////////////////
/// Handle the commands for the different menus
//////////////////////////////////////////////////////////////////////////
INT16 menuCommand(UINT16 menuNo, int command)
{
	INT16 nResult = CS_OK;
	int choice = -1;

	switch(menuNo)
	{
	case START_COMMANDS_MENU:
		nResult = CS_OK;
		// Handle user input
		switch(command) {
		case '0':
			csApiCall.connectCamera();
			if(csApiCall.isConnected())
			{

				nCurrentSetting = csApiCall.getCurrentSettingNumber();
				clear();
			}
			displayMenu(START_COMMANDS_MENU);
			break;
		case '1':
			nResult = RAW_COMMANDS_MENU;
			break;
		case '2':
			nResult = COMMAND_MENU1;			
			break;
		case '3':
			nResult = COMMAND_MENU2;			
			break;
		case '4':
			nResult = COMMAND_MENU3;			
			break;
		case '5':
			nResult = COMMAND_MENU4;			
			break;
		case '6':
			nResult = COMMAND_MENU5;			
			break;
		case '7':
			nResult = COMMAND_DEBUG;			
			break;
		case '8':
			// autodetect cameras
			csApiCall.autoDetectCameras();
			break;
		}
		break;
	case RAW_COMMANDS_MENU:
		nResult = CS_OK;
		// Handle user input
		switch(command) {
		case '0':
			csApiCall.getBinTag();
			break;
		case '1':
			csApiCall.sendBinTag();
			break;
		case '2':
			csApiCall.getShortTag();
			break;
		case '3':
			csApiCall.sendShortTag();
			break;
		case '4':
			csApiCall.getLongTag();
			break;
		case '5':
			csApiCall.sendLongTag();
			break;
		case '6':
			csApiCall.getVarTag();
			break;
		case '7':
			csApiCall.sendVarTag();
			break;
		case '8':
			csApiCall.sendHSIFile();
			break;
		case '9':
			csApiCall.sendFileList2Camera();
			break;
		case 'a':
			csApiCall.getRegisterValue();
			break;
		case 'b':
			csApiCall.setRegisterValue();
			break;
		case 'c':
			csApiCall.getShortTagCyclic();
			break;
		default:
			break;
		}
		break;
	case COMMAND_MENU1:
		nResult = CS_OK;
		// Handle user input
		switch(command) {
		case '0':
			csApiCall.selectSetting();
			nCurrentSetting = csApiCall.getCurrentSettingNumber();
			break;
		case '1':
			csApiCall.showAvailableSettings();
			break;
		case '2':
			csApiCall.burnSettingToCamera();
			break;
		case '3':
			csApiCall.saveCurrentSetting();
			break;
		case '4':
			csApiCall.getSettingDescription();
			break;
		case '5':
			csApiCall.setSettingDescription();
			break;
		case '6':
			if(csApiCall.isConnected())
			{
				printf("\nResetting camera ......\n");
				csApiCall.resetCamera();
				nCurrentSetting = csApiCall.getCurrentSettingNumber();
				printf("Reset done\n");
			}
			break;
		case '7':
			csApiCall.getReferenceSettings();
			break;
		case '8':
			csApiCall.setReferenceSettings();
			break;
		case '9':
			csApiCall.prepareCam4Reference();
			break;
		case 'a':
			clear();
			csApiCall.calculateReference();
			textattr(FOREGROUND_GREEN|FOREGROUND_INTENSITY);
			printf("\nPress key to continue");
			_getch();
			nResult = COMMAND_MENU1;			
			break;
		case 'b':
			csApiCall.create_reference_internally();
			break;
		default:
			break;
		}
		break;
		case COMMAND_MENU2:
			// Handle user input
			if(csApiCall.determineCameraType() != ALLPIXA_WAVE)
			{
				switch(command) {
					nResult = CS_OK;
				case '0':
					if(csApiCall.determineCameraType() != ALLPIXA_WAVE)
						csApiCall.getGainValues();
					else
						csApiCall.getLinearGainValues();
					break;
				case '1':
					if(csApiCall.determineCameraType() != ALLPIXA_WAVE)
						csApiCall.setGainValues();
					else
						csApiCall.setLinearGainValues();
					break;
				case '2':
					csApiCall.getInitialGainValues();
					break;
				case '3':
					csApiCall.setInitialGainValues();
					break;
				case '4':
					csApiCall.getCDSGainValues();
					break;
				case '5':
					csApiCall.setCDSGainValues();
					break;
				case '6':
					csApiCall.getCurrentWhiteReferenceValues();
					break;
				case '7':
					clear();
					csApiCall.getCameraWhiteBalancingSetup();
					textattr(FOREGROUND_GREEN|FOREGROUND_INTENSITY);
					printf("\nPress key to continue");
					_getch();
					nResult = COMMAND_MENU2;			
					break;
				case '8':
					clear();
					csApiCall.setCameraWhiteBalancingSetup();
					textattr(FOREGROUND_GREEN|FOREGROUND_INTENSITY);
					printf("\nPress key to continue");
					_getch();
					nResult = COMMAND_MENU2;			
					break;
				case '9':
					csApiCall.checkWhiteBalance();
					break;
				case 'a':
					csApiCall.doTabBalancing();
					break;
				case 'b':
					csApiCall.getCameraState();
					break;
				default:
					break;
				}
			}
			else
			{
				switch(command) {
					nResult = CS_OK;
				case '0':
					csApiCall.getLinearGainValues();
					break;
				case '1':
					csApiCall.setLinearGainValues();
					break;
				case '2':
					csApiCall.getSensorSensitivityValues();
					break;
				case '3':
					csApiCall.setSensorSensitivityValues();
					break;
				case '4':
					csApiCall.getCurrentWhiteReferenceValues();
					break;
				case '5':
					clear();
					csApiCall.getCameraWhiteBalancingSetup();
					textattr(FOREGROUND_GREEN|FOREGROUND_INTENSITY);
					printf("\nPress key to continue");
					_getch();
					nResult = COMMAND_MENU2;			
					break;
				case '6':
					clear();
					csApiCall.setCameraWhiteBalancingSetup();
					textattr(FOREGROUND_GREEN|FOREGROUND_INTENSITY);
					printf("\nPress key to continue");
					_getch();
					nResult = COMMAND_MENU2;			
					break;
				case '7':
					csApiCall.checkWhiteBalance();
					break;
				case '8':
					csApiCall.getCameraState();
					break;
				default:
					break;
				}
			}
			break;
		case COMMAND_MENU3:
			// Handle user input
			switch(command) {
				nResult = CS_OK;

			case '0':
				if(csApiCall.determineCameraType() != ALLPIXA_WAVE)
					csApiCall.getImageParameter();
				else
					csApiCall.getROIParameter();
				break;
			case '1':
				if(csApiCall.determineCameraType() != ALLPIXA_WAVE)
					csApiCall.setImageParameter();
				else
					csApiCall.setROIParameter();
				break;
			case '2':
				csApiCall.getIntegrationTimeSettings();
				break;
			case '3':
				csApiCall.setIntegrationTimeSettings();
				break;
			case '4':
				csApiCall.getCamLinkProps ();
				break;
			case '5':
				csApiCall.setCamLinkProps ();
				break;
			case '6':
				csApiCall.getBrightnessAndContrast();
				break;
			case '7':
				csApiCall.setBrightnessAndContrast();
				break;
			case '8':
				csApiCall.getImageProcessingParameter();
				break;
			case '9':
				csApiCall.setImageProcessingParameter();
				break;
			default:
				break;
			}
			break;
		case COMMAND_MENU4:
			// Handle user input
			switch(command) {
				nResult = CS_OK;
			case '0':
				csApiCall.getPhysicalSetupParameter();
				break;
			case '1':
				csApiCall.setPhysicalSetupParameter();
				break;
			case '2':
				csApiCall.getVideoOutputParameter();
				break;
			case '3':
				csApiCall.setVideoOutputParameter();
				break;
			case '4':
				csApiCall.getTriggerSettings();
				break;
			case '5':
				csApiCall.setTriggerSettings();
				break;
			case '6':
				csApiCall.getEncoderParameters();
				break;
			case '7':
				csApiCall.setEncoderParameters();
				break;
			case '8':
				csApiCall.getIOConfigurationParameter();
				break;
			case '9':
				csApiCall.setIOConfigurationParameter();
				break;
			case 'a':
				clear();
				csApiCall.get_camera_operating_values();
				textattr(FOREGROUND_GREEN|FOREGROUND_INTENSITY);
				printf("\nPress key to continue");
				_getch();
				nResult = COMMAND_MENU4;			
				break;
			case 'b':
				csApiCall.get_camera_information();
				break;
			default:
				break;
			}
			break;
		case COMMAND_MENU5:
			// Handle user input
			switch(command) {
				nResult = CS_OK;
			case '0':
				csApiCall.getLedFlashSettings();
				break;
			case '1':
				csApiCall.setLedFlashSettings();
				break;
			case '2':
				csApiCall.getFileFromCameraFlash();
				break;
			case '3':
				csApiCall.sendFile2CameraFlash();
				break;
			case '4':
				csApiCall.getImageDataFromCamera();
				break;
			default:
				break;
			}
			break;

		case COMMAND_DEBUG:
			// Handle user input
            switch(command) {
                nResult = CS_OK;
            case '0':
                csApiCall.getTestPatternSettings();
                break;
            case '1':
                csApiCall.setTestPatternSettings();
				break;
            case '2':
                csApiCall.getLoggingParameter();
                break;
			case '3':
				csApiCall.setLoggingParameter();
				break;
			case '4':
				csApiCall.get_trace_mode();
				break;
			case '5':
				csApiCall.set_trace_mode();
				break;
			case '6':
				clear();
				csApiCall.get_camera_trace();
				textattr(FOREGROUND_GREEN|FOREGROUND_INTENSITY);
				printf("\nPress key to continue");
				_getch();
				nResult = COMMAND_DEBUG;			
				break;
			default:
				break;
			}
			break;
		default:
			break;
	}
	return nResult;
}
//////////////////////////////////////////////////////////////////////////////////////////////
/// Main function of the console program
//////////////////////////////////////////////////////////////////////////////////////////////
int _tmain(int argc, _TCHAR* argv[])
{
	UINT16 currentMenu = START_MENU;

	// Clear the console
	clear();


	//////////////////////////////////////////////////////////////////////////////////////////////
	// Initialize the API
	//////////////////////////////////////////////////////////////////////////////////////////////
	INT16 result = csApiCall.InitAPI();
	if(result == CS_OK)
	{
			
		// This piece of code hides the cursor !!
		HANDLE hConsoleOutput;
		CONSOLE_CURSOR_INFO structCursorInfo;
		hConsoleOutput = GetStdHandle( STD_OUTPUT_HANDLE );
		GetConsoleCursorInfo( hConsoleOutput, &structCursorInfo );
		structCursorInfo.bVisible = FALSE;
		SetConsoleCursorInfo( hConsoleOutput, &structCursorInfo );

		bool bRun = true;
		clear();
		displayMenu(currentMenu);
		while(bRun)
		{
				
			//				gotoxy(xPos, yPos + MAXITEMS*nYStep );
			// Wait for user input
			int choice = _getch();
			clear();
			displayMenu(currentMenu);

			switch(choice)
			{
			case 'q':
			case 'Q':
				{
					int color = FOREGROUND_RED|FOREGROUND_INTENSITY;
					textattr(color);
					printf("\n\nDo you really want to quit (Press 'y' to end the program)?");
					choice = _getch();
					if((choice == 'y') || (choice == 'Y'))
						bRun = false;
					else
						clear();
				}
				break;
			case 'm':
			case 'M':
				currentMenu = START_COMMANDS_MENU;
				clear();
				displayMenu(currentMenu);
				break;
			default:
				choice = menuCommand(currentMenu, choice);
				if((choice > 0) && choice <= 7)
				{
					currentMenu = choice;
					clear();
					displayMenu(currentMenu);
				}
			}

//				gotoxy(xPos, yPos + MAXITEMS*nYStep );

				
		}

// 			printf(("Finished, press Enter!"));
// 			_getch();
	}
	return 0;
}

