#define _WIN32_WINNT 0x0502

#include <tchar.h>
#include <iostream>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <Windows.h>
#include <atlimage.h>
#include "math.h"
#include <iostream>
#include <fstream>

#include "displayHelper.h"
#include "ChromasensApiCalls.h"



#pragma comment(lib, "CS_API.lib")
CChromasensApiCalls::CChromasensApiCalls(void)
{
	m_camera=NULL;
	m_isConnected = false;
	m_hCamIfLib = NULL;
	m_tagID = 0x0000;		
}


CChromasensApiCalls::~CChromasensApiCalls(void)
{
	// Close the interface again
	if(m_camera)
	{
		m_camera->close_control();
		delete m_camera;
		m_camera = NULL;
	}
}


//////////////////////////////////////////////////////////////////////////
/// To load the Chromasens API call this function
//////////////////////////////////////////////////////////////////////////
INT16 CChromasensApiCalls::InitAPI()
{
	INT16 nReturn = CS_GENERAL_ERROR;
	// Load the Chromasens API-DLL
	HINSTANCE m_hCamIfLib = LoadLibrary(_T("CS_API.dll"));
	if(m_hCamIfLib == NULL)
	{
		wchar_t path[_MAX_PATH];
		wchar_t* pPath=NULL;
		HMODULE hModule = GetModuleHandle(_T("API_test.exe"));

		DWORD r = GetModuleFileName(hModule , path , 255 );
		wchar_t *end = StrRChrW( path , path + wcslen(path)-1, '\\');
		end--;
		*end = 0;
		
		end = StrRChrW( path , path + wcslen(path)-1 - wcslen(end), '\\');
		// Select the top level directory
		*end = 0;
		//pPath = _strdup(path);
		
		wchar_t static old_dir[MAX_PATH];
		GetCurrentDirectory(MAX_PATH,old_dir);
		SetCurrentDirectory(path);
		// try again to load the dll in the same directory (Chromasens setup)
		m_hCamIfLib = LoadLibrary(_T("../CS_API.dll"));
		SetDllDirectory(NULL);
		SetCurrentDirectory(old_dir);

	}

	if(m_hCamIfLib)
	{

		//////////////////////////////////////////////////////////////////////////////////////////////
		// Initialize the API
		//////////////////////////////////////////////////////////////////////////////////////////////
		// It is possible to choose another directory, simply use it in the constructor.
		// Otherwise the API will look for a "config" directory in the folder where the binaries are or here:(Starting from the binaries folder) ..\..\config.
		//m_camera = InitCsCameraIf("C:/Daten/Projekte/CST/CST-Trunk/bin/config");
		m_camera = InitCsCameraIf();
		if(m_camera)
		{
			nReturn = CS_OK;
		}
	}
	return CS_OK;
}

//////////////////////////////////////////////////////////////////////////
/// Close the camera and free the resources
//////////////////////////////////////////////////////////////////////////
INT16 CChromasensApiCalls::closeInterface(void)
{
	INT16 nReturn = CS_OK;
	// Close the interface again
	if(m_camera)
	{
		nReturn = m_camera->close_control();
		if(m_camera)
		{
			delete m_camera;
			m_camera = NULL;
		}
	}
	return nReturn;
}

//////////////////////////////////////////////////////////////////////////
/// Handles the connection to the m_camera
//////////////////////////////////////////////////////////////////////////
int CChromasensApiCalls::connectCamera (void)
{
	CS_CONNECTION_STRUCT connectInfo;

	// Open a connection to the m_camera -> a dialog will be displayed to let the user choose the connection parameter
	// The chosen parameters are returned by the system
	// To preselect any options fill the structure passed to the function with the desired values
	int nReturn = CS_GENERAL_ERROR; 

	if(m_camera == NULL)
	{
//		return CS_POINTER_GIVEN_IS_ZERO;
		m_camera = InitCsCameraIf();
		if(!m_camera)
			return CS_POINTER_GIVEN_IS_ZERO;
	}
	textattr(ENABLED);
	printf("Following interfaces are available:");
	list_available_interfaces();
	printf("\nChoose the type of connection: \n");
	printf("(0) Choose yourself: \n");
	printf("(1) RS232\n");
	printf("(2) CameraLink\n");
	printf("(q) Quit");

	int nChoice = _getch();
	if((nChoice >= 0) && (nChoice <= 2))
	{

		nReturn = m_camera->close_control();
		if(nReturn != CS_OK)
		{
			printf("Error closing control!");
			return nReturn;
		}
	}

	switch (nChoice)
	{
	case '0':
		nReturn = m_camera->open_control(&connectInfo);
		break;
	case '1':
		// Directly connect to the m_camera via a RS232 connection(Virtual com ports are also permissible
		{
			int nPort(0);
			int nBaudRate(115200);
			printf("\n\nPlease enter the desired COM-port: ");
			scanf_s("%d", &nPort);
			printf("Please enter the desired BAUD-Rate: ");
			scanf_s("%d", &nBaudRate);
			nReturn = m_camera->open_RS232_control(nPort, nBaudRate);
		}
		break;
	case '2':
		// Directly open a connection via cameraLink
		{
			int nPort(0);
			int nBaudRate(115200);
			printf("\n\nPlease enter the desired CameraLink-port: ");
			scanf_s("%d", &nPort);
			printf("Please enter the desired BAUD-Rate: ");
			scanf_s("%d", &nBaudRate);
			nReturn = m_camera->open_CL_control(nPort, nBaudRate);
		}
		break;
	default:
		m_isConnected  = false;
		break;
	}

	// check if the connection was successful
	if(nReturn == CS_OK)
	{
		printf("\nSuccessfully connected with: %s\n", connectInfo.connectionDescription);
		m_isConnected = true;
	}
	else
	{
		textattr(FOREGROUND_RED | FOREGROUND_INTENSITY);
		printf("\nFailed to connect to m_camera error code:%d\n", nReturn);
		m_isConnected  = false;
	}
	return nReturn;
}

//////////////////////////////////////////////////////////////////////////
/// Prompts the user to input the data for the sending of an bin tag
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::sendBinTag(void)
{
	if(m_isConnected)
	{
		bool value = false;
		int nTmp;
		int internalTagID = 0x0000;
		printf("\n\n------------------------------------------------------------------\n");
		printf("Please enter the tag ID (BIN) to send: ");
		if(scanf_s("%x", &internalTagID) > 0)
			m_tagID = internalTagID;
		printf("Please enter the Value (BIN) to send(0, 1): ");

		if(scanf_s("%d", &nTmp) <= 0)
			nTmp = 0;
		if(nTmp > 0) 
			value = true;
		else
			value = false;

		// Check if a valid tagID is present
		if(m_tagID != 0)
		{
			int nReturn = m_camera->send_bin_tag(m_tagID, value) ;
			if(nReturn != CS_OK)
			{
				printf("Error sending Bin-Tag: %d", nReturn);
			}
			else
				printf("\nSend of BIN-tag 0x%x succeeded!", m_tagID);
		}
		else
		{
			printf("Error: Entered TagId is not valid: %d", m_tagID);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
// Read a bin value from the m_camera
// The get function by default does not request another response from the m_camera
// The value read will be the value obtained by the last get call with the update parameter set to true
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getBinTag(void)
{
	if(m_isConnected)
	{
		bool value = false;
		int internalTagID = 0x0000;
		printf("\n\n------------------------------------------------------------\n");
		printf("Please enter the tag ID (BIN) to get(in HEX): ");
		if(scanf_s("%x", &internalTagID) > 0)
			m_tagID = (WORD)internalTagID;

		// Check if a valid m_tagID is present
		if(m_tagID != 0)
		{
			int nReturn = m_camera->get_bin_tag(m_tagID, value, true) ;
			if(nReturn != CS_OK)
			{
				printf("Error getting Bin-Tag: %d", nReturn);
			}
			else
			{
				printf("\nRead BIN-Value: %d", value);
			}
		}
		else
		{
			printf("Error: Entered TagId is not valid: %d", m_tagID);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}


//////////////////////////////////////////////////////////////////////////
/// Sends a short tag to the m_camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::sendShortTag(void)
{
	if(m_isConnected)
	{
		int value = 0;
		int internalTagID = 0x0000;
		printf("\n\n-------------------------------------------------------\n");
		printf("Please enter the tag ID (SHORT) to send: ");
		if(scanf_s("%x", &internalTagID) > 0)
			m_tagID = (WORD)internalTagID;
		printf("Please enter the Value (SHORT) to send(decimal): ");
		if(scanf_s("%d", &value) <= 0)
			value = 0;

		// Check if a valid m_tagID is present
		if(m_tagID != 0)
		{
			int nReturn = m_camera->send_short_tag(m_tagID, value) ;
			if(nReturn != CS_OK)
			{
				printf("Error sending SHORT-Tag: %d", nReturn);
			}
			else
				printf("\nSend of SHORT-tag 0x%x succeeded!", m_tagID);
		}
		else
		{
			printf("Error: Entered TagId is not valid: %d", m_tagID);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");


}

//////////////////////////////////////////////////////////////////////////
/// Reads a given short tag from the m_camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getShortTag(void)
{
	if(m_isConnected)
	{
		WORD value = 0;
		int internalTagID = 0x0000;
		printf("\n\n--------------------------------------------------------\n");
		printf("Please enter the tag ID (SHORT) to get: ");
		if(scanf_s("%x", &internalTagID) > 0)
			m_tagID = internalTagID;

		// Check if a valid m_tagID is present
		if(m_tagID != 0)
		{
			int nReturn = m_camera->get_short_tag(m_tagID, value, true) ;
			if(nReturn != CS_OK)
			{
				printf("Error getting SHORT-Tag: %d", nReturn);
			}
			else
			{
				printf("\nRead SHORT-Value: %d", value);
			}
		}
		else
		{
			printf("Error: Entered TagId is not valid: %d", m_tagID);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Reads a given short tag from the m_camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getShortTagCyclic(void)
{
	if(m_isConnected)
	{
		WORD value = 0;
		int internalTagID = 0x0000;
		int cycleTime = 1000;
		int tmp; 
		printf("\n\n--------------------------------------------------------\n");
		printf("Please enter the tag ID (SHORT) to get: ");
		if(scanf_s("%x", &internalTagID) > 0)
			m_tagID = internalTagID;

		printf("\nPlease enter the cycleTime in ms: ");
		if(scanf_s("%d", &tmp) > 0)
			cycleTime = tmp;
		printf("\nPress key to cancel!");

		while(!_kbhit())
		{
			// Check if a valid m_tagID is present
			if(m_tagID != 0)
			{
				int nReturn = m_camera->get_short_tag(m_tagID, value, true) ;
				if(nReturn != CS_OK)
				{
					printf("Error getting SHORT-Tag: %d", nReturn);
				}
				else
				{
					printf("\nRead SHORT-Value: %d", value);
				}
			}
			else
			{
				printf("Error: Entered TagId is not valid: %d", m_tagID);
			}
			if(value > 3)
			{
				printf("\nRead unexpected SHORT-Value: %d\nPress key to continue", value);
				_getch();
			}
			Sleep(cycleTime);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}
//////////////////////////////////////////////////////////////////////////
/// Sends a long tag to the m_camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::sendLongTag(void)
{
	if(m_isConnected)
	{
		long value = 0;
		int internalTagID = 0x0000;
		printf("\n\n----------------------------------------------------\n");
		printf("Please enter the tag ID (LONG) to send: ");
		if(scanf_s("%x", &internalTagID) > 0)
			m_tagID = internalTagID;
		printf("Please enter the Value (LONG) to send(decimal): ");
		if(scanf_s("%ld", &value) <= 0)
			value = 0;

		// Check if a valid m_tagID is present
		if(m_tagID != 0)
		{
			int nReturn = m_camera->send_long_tag(m_tagID, value) ;
			if(nReturn != CS_OK)
			{
				printf("Error sending LONG-Tag: %d", nReturn);
			}
			else
				printf("\nSend of LONG-tag 0x%x succeeded!", m_tagID);
		}
		else
		{
			printf("Error: Entered TagId is not valid: %d", m_tagID);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Reads a long tag from the m_camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getLongTag(void)
{
	if(m_isConnected)
	{
		DWORD value = 0;
		int internalTagID = 0x0000;
		printf("\n\n---------------------------------------------------------\n");
		printf("Please enter the tag ID (LONG) to get: ");
		if(scanf_s("%x", &internalTagID) > 0)
			m_tagID = internalTagID;

		// Check if a valid m_tagID is present
		if(m_tagID != 0)
		{
			int nReturn = m_camera->get_long_tag(m_tagID, value, true) ;
			if(nReturn != CS_OK)
			{
				printf("Error getting LONG-Tag: %d", nReturn);
			}
			else
			{
				printf("\nRead LONG-Value: %ld", value);
			}
		}
		else
		{
			printf("Error: Entered TagId is not valid: %d", m_tagID);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Sends a var tag to the m_camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::sendVarTag(void)
{
	if(m_isConnected)
	{
		WORD* pValue = NULL;
		int nLength = 0;
		int internalTagID = 0x0000;
		printf("\n\n----------------------------------------------------------\n");
		printf("Please enter the tag ID (VAR) to send: ");
		if(scanf_s("%x", &internalTagID) > 0)
			m_tagID = internalTagID;
		printf("Please enter the number of contained values: ");
		if(scanf_s("%d", &nLength) <= 0)
			nLength = 0;
		pValue = new WORD[nLength];
		for(int i = 0; i < nLength; i++)
		{
			int nTmp=0;
			printf("Please enter the VAR-Element No.%d (decimal): ", i);
			if(scanf_s("%d", &nTmp) <= 0)
				nTmp = 0;

			pValue[i] = nTmp;
		}

		// Check if a valid m_tagID is present
		if(m_tagID != 0)
		{
			int nReturn = m_camera->send_var_tag(m_tagID, nLength, pValue) ;
			if(nReturn != CS_OK)
			{
				printf("Error sending VAR-Tag: %d", nReturn);
			}
			else
				printf("\nSend of VAR-tag 0x%x succeeded!", m_tagID);
		}
		else
		{
			printf("Error: Entered TagId is not valid: %d", m_tagID);
		}
		if(pValue)
		{
			delete[] pValue;
			pValue = NULL;
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Reads a var tag from the m_camera 
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getVarTag(void)
{
	if(m_isConnected)
	{
		WORD* value = NULL;
		int nLength=0;
		int internalTagID = 0x0000;

		printf("\n\n-------------------------------------------------------\n");
		printf("Please enter the tag ID (VAR) to get: ");
		if(scanf_s("%x", &internalTagID) > 0)
			m_tagID = internalTagID;
		printf("Please enter the number of elements in the var tag: ");
		scanf_s("%d", &nLength);

		value = new WORD[nLength];

		// Check if a valid m_tagID is present
		if(m_tagID != 0)
		{
			int nReturn = m_camera->get_var_tag(m_tagID, nLength, value, true) ;
			if(nReturn != CS_OK)
			{
				printf("Error getting VAR-Tag: %d", nReturn);
			}
			else{
				printf("\nVar tag 0x%x contains:\n", m_tagID);
				for(int i = 0; i < nLength; i++)
				{
					printf("Element %d: %d\n", i, value[i]);
				}
			}
		}
		else
		{
			printf("Error: Entered TagId is not valid: %d", m_tagID);
		}

		// Clean up memory
		if(value)
			delete value;
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Function will print the available settings of the m_camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::showAvailableSettings(void)
{
	if(m_isConnected)
	{
		INT64 nReturn = m_camera->get_available_settings();
		if(nReturn >= CS_OK)
		{
			printf("\n\nSettings available on the m_camera:\n");
			for(INT64 i = MIN_SETTING_NO; i <= MAX_SETTING_NO; i++)
			{
				if(nReturn & (1i64 << i))
					printf("%d, ", i);
			}
		}
		else
		{
			textattr(FOREGROUND_RED | FOREGROUND_INTENSITY);
			printf("\nError getting the available settings: %d\n", nReturn);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Function will select a different setting
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::selectSetting(void)
{
	if(m_isConnected)
	{
		int nSettingNo = MIN_SETTING_NO;
		printf("\n\n-------------------------------------------------------\n");
		printf("Please enter the setting to select: ");
		scanf_s("%d", &nSettingNo);

		if((nSettingNo < MIN_SETTING_NO) || 
			(nSettingNo > MAX_SETTING_NO))
		{
			printf("Setting number requested is out of range! \n");
		}
		else
		{
			INT32 nReturn = m_camera->select_active_setting(nSettingNo);
			if(nReturn != CS_OK)
			{
				textattr(FOREGROUND_RED | FOREGROUND_INTENSITY);
				switch(nReturn)
				{
				case CS_ERROR_SETTING_NO_OUT_OF_RANGE:
					printf("\nError setting active setting: Setting number out of range\n");
					break;
				case CS_ERROR_HSI_SEND:
					printf("\nError setting active setting: Send of HSI-command failed\n");
					break;
				case CS_GENERAL_ERROR:
					printf("\nError setting active setting: Unspecified error\n");
					break;
				case CS_ERROR_SETTING_NOT_AVAILABLE:
					printf("\nError setting does not exist on the m_camera\n");
					break;
				default:
					printf("\nError setting active setting: Unknown error\n");
					break;
				}
			}
			else
				printf("Successfully activated setting No: %d", nSettingNo);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Function will return the currently active setting number
//////////////////////////////////////////////////////////////////////////
INT16 CChromasensApiCalls::getCurrentSettingNumber()
{
	if(m_isConnected)
	{
		return m_camera->get_current_setting_number();
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
	return CS_GENERAL_ERROR;
}

//////////////////////////////////////////////////////////////////////////
/// Function will save the current setting to disk
/// the output format can be chosen in between binary HSI-format or XML-format used in the CST
//////////////////////////////////////////////////////////////////////////
INT16 CChromasensApiCalls::saveCurrentSetting()
{
	INT16 nReturn = CS_OK;

	if(m_isConnected)
	{
		char fileName[MAX_PATH];
		printf("\nEnter the path and name where the setting should be saved to\n(use .set extension for XML-format):\n");
		if(scanf_s("%s", fileName, MAX_PATH) <= 0)
		{
			printf("Error entering file !")	;
		}

		int nSettingNo=-1;
		printf("Please enter the setting number where the current setting should be referenced to\n(enter 0 to use the currently active setting number): ");
		scanf_s("%d", &nSettingNo);

		int nSettingFormat= FORMAT_BINARY;
		printf("Please enter the file format (0=Binary, 1=XML): ");
		scanf_s("%d", &nSettingFormat);
		if(nSettingFormat == 0)
			nSettingFormat = FORMAT_BINARY;
		else
			nSettingFormat = FORMAT_XML;

		nReturn = m_camera->save_current_setting_2Disk(fileName, nSettingFormat,nSettingNo);
	}
	else
	{
		printf("\n !!! Camera is not connected !!!\n");
		nReturn = CS_CAM_NOT_CONNECTED;
	}
	return nReturn;
}

//////////////////////////////////////////////////////////////////////////
/// Function will get the description of the currently active setting from the camera
//////////////////////////////////////////////////////////////////////////
INT16 CChromasensApiCalls::getSettingDescription()
{
	INT16 nReturn = CS_OK;

	if(m_isConnected)
	{
		char settingDescription[MAX_SETTING_COMMENT_LENGTH];
		
		nReturn = m_camera->get_setting_description(settingDescription);
		if(nReturn == CS_OK)
		{
			printf("\nSetting comment:\n%s", settingDescription);
		}
		else
		{
			char* text;//[MAX_ERROR_TEXT_LENGTH];
			m_camera->get_error_text(nReturn, &text);

			printf("\nError getting setting comment: %d %s", nReturn, text);
		}
	}
	else
	{
		printf("\n !!! Camera is not connected !!!\n");
		nReturn = CS_CAM_NOT_CONNECTED;
	}
	return CS_OK;
}

//////////////////////////////////////////////////////////////////////////
/// Function will set the setting description into the camera
//////////////////////////////////////////////////////////////////////////
INT16 CChromasensApiCalls::setSettingDescription()
{
	INT16 nReturn = CS_OK;

	if(m_isConnected)
	{
		if(m_isConnected)
		{
			char settingDescription[MAX_SETTING_COMMENT_LENGTH];
			printf("\nEnter the setting description for the current setting:\n");
			if(gets_s(settingDescription, MAX_SETTING_COMMENT_LENGTH) <= 0)
			{
				printf("Error entering comment !")	;
				return CS_GENERAL_ERROR; 
			}

			nReturn = m_camera->set_setting_description(settingDescription);
			if(nReturn == CS_OK)
			{
				printf("\nSetting comment successfully set!");
			}
			else
				printf("\nError setting setting comment: %d", nReturn);
		}
		else
		{
			printf("\n !!! Camera is not connected !!!\n");
			nReturn = CS_CAM_NOT_CONNECTED;
		}
	}
	else
	{
		printf("\n !!! Camera is not connected !!!\n");
		nReturn = CS_CAM_NOT_CONNECTED;
	}
	return CS_OK;
}

//////////////////////////////////////////////////////////////////////////
/// Function will burn the current setting to the m_camera (if desired to another setting)
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::burnSettingToCamera(void)
{
	if(m_isConnected)
	{
		INT32 nReturn = CS_OK;
		INT32 nSettingNo=m_camera->get_current_setting_number();

		printf("\n\n-------------------------------------------------------\n");
		printf("Please enter the setting to select (Current setting is: %d: ", nSettingNo);
		scanf_s("%d", &nSettingNo);

		if((nSettingNo < MIN_SETTING_NO) || 
			(nSettingNo > MAX_SETTING_NO))
		{
			textattr(FOREGROUND_RED | FOREGROUND_INTENSITY);
			printf("Setting number requested is out of range! \n");
		}
		else
		{
			if(nReturn = m_camera->burn_current_setting_to_camera(nSettingNo) == CS_OK)
			{
				printf("Successfully burned setting to %d", nSettingNo);
			}
			else
			{
				textattr(FOREGROUND_RED | FOREGROUND_INTENSITY);
				printf("\n Error burning setting:%d! \n", nReturn);
			}
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Check if the white balancing is running correct (The camera will perform a 
/// white balancing with the currently active parameter)
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::checkWhiteBalance(void)
{
	if(m_isConnected)
	{
		printf("\n\nChecking white balancing .....");
		if(INT32 nReturn = m_camera->perform_white_balancing() != CS_OK)
		{
			textattr(FOREGROUND_RED | FOREGROUND_INTENSITY);
			printf("\nWhite balancing failed with error: %d!\n", nReturn);

			char* pError = NULL;
			// get the error message:
			int nErrorCode;
			nErrorCode = m_camera->get_camera_state(true, &pError);
			if(pError)
				printf("Explicit error message of code No.: %d: \n%s\n", nErrorCode, pError);
			else
				printf("Error code No.: %d: \n", nErrorCode);
		}
		else
		{
			printf("\n\nWhite balancing OK!");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Start a balancing between the two camera taps of the Allpixa camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::doTabBalancing(void)
{
	if(m_isConnected)
	{
		printf("\n\nDoing tap balancing .....");
		if(INT32 nReturn = m_camera->do_tap_balancing() != CS_OK)
		{
			textattr(FOREGROUND_RED | FOREGROUND_INTENSITY);
			printf("\nTap balancing failed with error: %x!\n", nReturn);

			char* pError = NULL;
			// get the error message:
			int nErrorCode;
			nErrorCode = m_camera->get_camera_state(true, &pError);
			if(pError)
				printf("Explicit error message of code No.: %x: \n%s\n", nErrorCode, pError);
			else
				printf("Error code No.: %x: \n", nErrorCode);
		}
		else
		{
			printf("\n\nTap balancing OK!");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Request the current operating state from mthe camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getCameraState(void)
{
	if(m_isConnected)
	{
		char* pError = NULL;
		// get the error message:
		int nErrorCode;
		printf("\n\nRequesting camera state .....\n");
		
		nErrorCode = m_camera->get_camera_state(true, &pError);
		if(nErrorCode != CS_OK)
		{
			if(pError)
				printf("Explicit error message of code No.: %x: \n%s\n", nErrorCode, pError);
			else
				printf("Error code No.: %x: \n", nErrorCode);
		}
		else
		{
			printf("Camera is running OK: %x: \n", nErrorCode);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Set the initial gain values of the Allpixa m_camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setInitialGainValues(void)
{
	if(m_isConnected)
	{
		// get the available number of gain values
		CS_CHANNEL_STRUCT initialGain;
		if(m_camera->get_initial_gain_values(&initialGain) == CS_OK)
		{
            printf("\n");
			for(int i = 0; i < initialGain.no_of_valid_entries; i++)
			{
				int nTmp=0;
				printf("Please enter the intial gain value No.%d (decimal): ", i);
				if(scanf_s("%d", &nTmp) <= 0)
					nTmp = 0;

				initialGain.value[i] = nTmp;
			}
			m_camera->set_initial_gain_values(initialGain);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Get the initial gain values of the Allpixa m_camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getInitialGainValues(void)
{
	if(m_isConnected)
	{
		// get the available number of gain values
		CS_CHANNEL_STRUCT initialGain;
		if(m_camera->get_initial_gain_values(&initialGain, true) == CS_OK)
		{
			printf("\n\nThe values of the initial gain settings:\n");
			for(int i = 0; i < initialGain.no_of_valid_entries; i++)
			{
				printf("Element %d: %d\n", i, initialGain.value[i]);
			}
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Get the current white reference values of the Allpixa m_camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getCurrentWhiteReferenceValues(void)
{
	if(m_isConnected)
	{
		// get the available number of gain values
		CS_CHANNEL_STRUCT whiteReferenceValues;
		if(m_camera->get_current_reference_values(&whiteReferenceValues, true) == CS_OK)
		{
			printf("\n\nThe values of the current white references:\n");
			for(int i = 0; i < whiteReferenceValues.no_of_valid_entries; i++)
			{
				printf("Element %d: %d\n", i, whiteReferenceValues.value[i]);
			}
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Set the gain values of the Allpixa m_camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setGainValues(void)
{
	if(m_isConnected)
	{
		// get the available number of gain values
		CS_CHANNEL_STRUCT gain;
		if(m_camera->get_gain_values(&gain) == CS_OK)
		{
			printf("\n");
			for(int i = 0; i < gain.no_of_valid_entries; i++)
			{
				int nTmp=0;
				printf("Please enter the Gain-Value No.%d (decimal): ", i);
				if(scanf_s("%d", &nTmp) <= 0)
					nTmp = 0;

				gain.value[i] = nTmp;
			}
			m_camera->set_gain_values(gain);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Get the analog coarse gain values of the Allpixa m_camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getCDSGainValues(void)
{
	if(m_isConnected)
	{
		// get the available number of gain values
		CS_ANALOG_COARSE_GAIN_STRUCT cdsGain;
		if(m_camera->get_coarse_gain_values(&cdsGain, true) == CS_OK)
		{
			char txt[200];
			printf("\n\nThe values of the coarse gainsettings:\n");
			for(int i = 0; i < cdsGain.no_of_valid_entries; i++)
			{

				switch(cdsGain.value[i]){
				case MINUS_3DB:
					strcpy_s(txt, "-3 dB");
					break;
				case _0_DB:
					strcpy_s(txt, " 0 dB");
					break;
				case _3_DB:
					strcpy_s(txt, " 3 dB");
					break;
				case _6_DB:
					strcpy_s(txt, " 6 dB");
					break;
				default:
					printf("invalid entry! ");
				}
				printf("Element %d: %s\n", i, txt);
			}
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Set the analog coarse gain values of the Allpixa m_camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setCDSGainValues(void)
{
	if(m_isConnected)
	{
		// get the available number of gain values
		CS_ANALOG_COARSE_GAIN_STRUCT cdsGain;
		if(m_camera->get_coarse_gain_values(&cdsGain) == CS_OK)
		{
			printf("Please enter one of the following values(-3, 0, 3 or 6)[dB]\n");
			for(int i = 0; i < cdsGain.no_of_valid_entries; i++)
			{
				int nTmp=0;
				printf("Please enter the coarse gain-Value No.%d (decimal): ", i);
				if(scanf_s("%d", &nTmp) <= 0)
					nTmp = 0;
				switch(nTmp){
				case -3:
					nTmp = MINUS_3DB;
					break;
				case 0:
					nTmp = _0_DB;
					break;
				case 3:
					nTmp = _3_DB;
					break;
				case 6:
					nTmp = _6_DB;
					break;
				default:
					printf("invalid entry! Will set the value to 0 dB");
					nTmp = _0_DB;
				}
				cdsGain.value[i] = nTmp;
			}
			m_camera->set_coarse_gain_values(cdsGain);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}
//////////////////////////////////////////////////////////////////////////
/// Set the white balancing parameters of the Allpixa camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setCameraWhiteBalancingSetup(void)
{
	float fTmp = 0.0;
	INT32 tmp=0; // Buffer variable because scanf is using 32 Bit values!

	if(m_isConnected)
	{
		// get the available number of gain values
		CS_WHITE_BALANCE_STRUCT whiteBalancingSetting;

		printf("\n\nPlease select if the white balancing should be turned on (0 or 1): ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		whiteBalancingSetting.enable_white_balancing = (tmp != 0);

		printf("Please enter the white reference target value(red): ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		whiteBalancingSetting.red_target_value = tmp;
		printf("Please enter the white reference target value(green): ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		whiteBalancingSetting.green_target_value = tmp;
		printf("Please enter the white reference target value(blue): ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		whiteBalancingSetting.blue_target_value = tmp;

		// The allPIXA wave does have an additional sensor line for grey images (This Line is called white)
		if(determineCameraType() == ALLPIXA_WAVE)
		{
			printf("Please enter the white reference target value(white): ");
			if(scanf_s("%d", &tmp) <= 0)
				tmp = 0;
			whiteBalancingSetting.white_target_value = tmp;
		}

		printf("Enter the number of frames to average for the white reference(0, 2, 4, 8, 16 or 32): ");
		if(scanf_s("%d", &tmp) <= 0)
			whiteBalancingSetting.frames_for_average = NO_AVERAGING;
		else{
			switch(tmp)
			{
			case 0:
				whiteBalancingSetting.frames_for_average = NO_AVERAGING;
				break;
			case 2:
				whiteBalancingSetting.frames_for_average = USE_2_SAMPLES_FOR_AVERAGING;
				break;
			case 4:
				whiteBalancingSetting.frames_for_average = USE_4_SAMPLES_FOR_AVERAGING;
				break;
			case 8:
				whiteBalancingSetting.frames_for_average = USE_8_SAMPLES_FOR_AVERAGING;
				break;
			case 16:
				whiteBalancingSetting.frames_for_average = USE_16_SAMPLES_FOR_AVERAGING;
				break;
			case 32:
				whiteBalancingSetting.frames_for_average = USE_32_SAMPLES_FOR_AVERAGING;
				break;
			default:
				whiteBalancingSetting.frames_for_average = NO_AVERAGING;
				break;
			}
		}
		printf("Please select if the stop gain control should be used(0 or 1): ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		whiteBalancingSetting.stopGainControl = (tmp != 0);
		printf("Enter the stop gain control factor: ");
		if(scanf_s("%e", &fTmp) <= 0)
			fTmp = 0.0;
		whiteBalancingSetting.gain_control_stop_factor = (float)(fTmp +  0.0005);

		// allPIXA wave does not consist of multiple taps, therefore this parameter is obsolete here
		if(determineCameraType() != ALLPIXA_WAVE)
		{
			printf("Select which tap is used for white balancing. \n");
			printf("0: Front tap is master\n");
			printf("1: Rear tap is master\n");
			printf("2: Independent white balancing\n");
			printf("3: Automatic master detection\n");
			if(scanf_s("%d", &tmp) <= 0)
				tmp = AUTOMATIC_MASTER_DETECTION;
			whiteBalancingSetting.multi_tap_mode = tmp;
		}

		printf("Should the white balancing be synchronized with the image frame(0/1): ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		whiteBalancingSetting.synchronizeWithFrame = (tmp != 0);

		printf("Enter the top position of the white balancing: ");
		if(scanf_s("%d", &whiteBalancingSetting.white_reference_area.top) <= 0)
			whiteBalancingSetting.white_reference_area.top= 0;
		printf("Enter the bottom position of the white balancing: ");
		if(scanf_s("%d", &whiteBalancingSetting.white_reference_area.bottom) <= 0)
			whiteBalancingSetting.white_reference_area.bottom= 0;
		printf("Enter the left position of the white balancing: ");
		if(scanf_s("%d", &whiteBalancingSetting.white_reference_area.left) <= 0)
			whiteBalancingSetting.white_reference_area.left= 0;
		printf("Enter the right position of the white balancing: ");
		if(scanf_s("%d", &whiteBalancingSetting.white_reference_area.right) <= 0)
			whiteBalancingSetting.white_reference_area.right= 0;

		printf("Display the white balancing borders in the image(0 or 1): ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		whiteBalancingSetting.showWhiteReferenceBorders = (tmp != 0);
		// Currently only one white balancing mode is possible, therefore we do not ask the value from the user
		whiteBalancingSetting.white_balancing_mode = GAIN_CONTROL_USING_AREA_RANGE;

		INT16 nError = m_camera->set_camera_white_balancing_setup(whiteBalancingSetting);
		if( nError != CS_OK)
		{
			printf ("Error setting the white reference target values: %d\n", nError);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Get the currently set white balancing parameters
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getCameraWhiteBalancingSetup(void)
{
	if(m_isConnected)
	{
		CS_WHITE_BALANCE_STRUCT whiteBalanceParams;

		INT16 nReturn = m_camera->get_camera_white_balancing_setup(&whiteBalanceParams, true);
		if(nReturn == CS_OK)
		{
			printf("\n\nWhite balancing parameters:\n");
			printf("White balancing On:\t\t%d\n", whiteBalanceParams.enable_white_balancing);
			printf("Target Value(red):\t\t%d\n", whiteBalanceParams.red_target_value);
			printf("Target Value(green):\t\t%d\n", whiteBalanceParams.green_target_value);
			printf("Target Value(blue):\t\t%d\n", whiteBalanceParams.blue_target_value);
			if(whiteBalanceParams.white_target_value != PARAMETER_NOT_USED)
				printf("Target Value(white):\t\t%d\n", whiteBalanceParams.white_target_value);

			printf("Frames for average:\t\t%d\n", (int)(pow(2.0, whiteBalanceParams.frames_for_average)));
			printf("Use stop gain control:\t\t%d\n", whiteBalanceParams.stopGainControl);
			printf("Stop gain control factor:\t%5.3f\n", whiteBalanceParams.gain_control_stop_factor);
			char text[200];
			if(whiteBalanceParams.multi_tap_mode != PARAMETER_NOT_USED)
			{
				switch(whiteBalanceParams.multi_tap_mode)
				{
				case FRONT_TAP_IS_MASTER:
					strcpy_s(text, "Front tap is master");
					break;
				case REAR_TAP_IS_MASTER:
					strcpy_s(text, "Rear tap is master");
					break;
				case INDEPENDENT_WHITE_BALANCING:
					strcpy_s(text, "Tap independent white balancing");
					break;
				case AUTOMATIC_MASTER_DETECTION:
					strcpy_s(text, "Automatic master detection");
					break;
				default:
					strcpy_s(text, "Unknown tap balancing mode");
					break;
				}
				printf("Multi tap mode:\t\t\t%s\n", text);
			}
			switch(whiteBalanceParams.white_balancing_mode)
			{
			case GAIN_CONTROL_USING_AREA_RANGE:
				strcpy_s(text, "Gain control using area range");
				break;
			case USE_MAXIMUM_VIDEO_LEVEL:
				strcpy_s(text, "Gain control using maximum video level in line");
				break;
			case ODD_EVEN_CORRECTION_BY_LINE_AVG:
				strcpy_s(text, "Gain control using odd even correction");
				break;
			default:
				strcpy_s(text, "Unknown gain control mode");
				break;
			}
			printf("Gain control mode:\t\t%s\n", text);
			printf("Synchronize with frame:\t\t%d\n", whiteBalanceParams.synchronizeWithFrame);
			printf("Show white reference borders:\t%d\n", whiteBalanceParams.showWhiteReferenceBorders);
			printf("Top:\t\t\t\t%d\n", whiteBalanceParams.white_reference_area.top);
			printf("Botom:\t\t\t\t%d\n", whiteBalanceParams.white_reference_area.bottom);
			printf("Left:\t\t\t\t%d\n", whiteBalanceParams.white_reference_area.left);
			printf("Right:\t\t\t\t%d\n", whiteBalanceParams.white_reference_area.right);
		}
		else
		{
			char *pErrorTxt=NULL;
			printf("Getting the white balancing Params failed!\n");
			m_camera->get_error_text(nReturn, &pErrorTxt);
			int color = FOREGROUND_RED|FOREGROUND_INTENSITY;
			textattr(color);
			if(pErrorTxt)
				printf("Error: %x, %s\n", nReturn, pErrorTxt);
			else
				printf("Error: %x\n", nReturn);

			printf("\nPlease enter key");
			_getch();
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Get the gain values of the Allpixa m_camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getGainValues(void)
{
	if(m_isConnected)
	{
		// get the available number of gain values
		CS_CHANNEL_STRUCT gain;
		if(m_camera->get_gain_values(&gain, true) == CS_OK)
		{
			printf("\n\nThe values of the gain settings:\n");
			for(int i = 0; i < gain.no_of_valid_entries; i++)
			{
				printf("Element %d: %d\n", i, gain.value[i]);
			}
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Returns the connection state of the API
//////////////////////////////////////////////////////////////////////////
bool CChromasensApiCalls::isConnected( void )
{
	return m_isConnected;
}

//////////////////////////////////////////////////////////////////////////
/// Resets the camera and establishes a new connection to it
//////////////////////////////////////////////////////////////////////////
INT16 CChromasensApiCalls::resetCamera()
{
	INT16 nReturn = CS_GENERAL_ERROR;

	if(m_isConnected)
	{
		nReturn = m_camera->reset_camera();
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
	return nReturn;
}

//////////////////////////////////////////////////////////////////////////
/// Determines the connected camera type
//////////////////////////////////////////////////////////////////////////
INT16 CChromasensApiCalls::determineCameraType()
{
	INT16 nReturn = CS_GENERAL_ERROR;

	if(m_isConnected)
	{
		nReturn = m_camera->determineCameraType(false); // No need to update again. Already called when connected to camera
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
	return nReturn;
}

//////////////////////////////////////////////////////////////////////////
/// Get the currently active test pattern settings
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getTestPatternSettings( void )
{
	if(m_isConnected)
	{
		CS_TEST_PATTERN_STRUCT testPattern;
		if(m_camera->get_test_pattern_settings(&testPattern, true) == CS_OK) 
		{
			char text[200];
			switch(testPattern.nTestPattern)
			{
			case TEST_PATTERN_OFF:
				strcpy_s(text, "Test patterns is switched off");
				break;
			case GREY_RAMP_IN_CCD_DIR:
				strcpy_s(text, "Grey ramp in CCD direction");
				break;
			case GREY_RAMP_IN_TRANSPORT_DIR:
				strcpy_s(text, "Grey ramp in transport direction");
				break;
			case INPUT_RAMP_ON_GREEN_CHANNEL:
				strcpy_s(text, "Ramp in the green channel (red and blue set on test pattern level)");
				break;
			case SEQUENCE_OF_PATTERNS:
				strcpy_s(text, "Alternating test patterns");
				break;
			case CHANGE_VIDEO_LEVEL_AT_EVERY_PIXEL:
				strcpy_s(text, "Video levels are changed for each pixel");
				break;
			default:
				strcpy_s(text, "Unknown test pattern");
				break;
			}
			printf("\n\nTest pattern:\t%s\n", text);
			printf("Test pattern level:\t%d\n", testPattern.nTestPatternLevel);
		}
		else
		{
			// Error getting the test pattern settings
			printf("\n\nError getting the test pattern setting!");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Set test pattern settings
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setTestPatternSettings( void )
{
	if(m_isConnected)
	{
		CS_TEST_PATTERN_STRUCT testPattern;
		int tmp;
		printf("\n\nEnter the desired test pattern! \n");
		printf("\nTest pattern off: \t\t\t%d ", TEST_PATTERN_OFF);
		printf("\nGrey ramp in CCD direction: \t\t%d ", GREY_RAMP_IN_CCD_DIR);
		printf("\nGrey ramp in transport direction: \t%d ", GREY_RAMP_IN_TRANSPORT_DIR);
		printf("\nRamp in green channel: \t\t\t%d ", INPUT_RAMP_ON_GREEN_CHANNEL);
		printf("\nSequence of patterns: \t\t\t%d ", SEQUENCE_OF_PATTERNS);
		printf("\nChange video for every channel: \t%d \n", CHANGE_VIDEO_LEVEL_AT_EVERY_PIXEL);
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		testPattern.nTestPattern = tmp;

		printf("Enter the desired test pattern level:");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		testPattern.nTestPatternLevel = tmp;
		if(m_camera->set_test_pattern_settings(testPattern) != CS_OK)
		{
			// Error setting the test pattern value!
			printf("\n\nError setting the test pattern!");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Get the currently active integration time and line period parameter
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getIntegrationTimeSettings( void )
{
	if(m_isConnected)
	{
		CS_INTEGRATION_TIME_STRUCT integrationTime;
		if(m_camera->get_integration_time(&integrationTime, true) == CS_OK)
		{
			printf("\n\nIntegration time in ns: %d", integrationTime.integration_time_in_ns);
			// allPIXA wave does not evaluate the line period feature, it is enabled by default
			if(determineCameraType() != ALLPIXA_WAVE)
				printf("\nLine period feature: \t%d", (integrationTime.use_line_period_feature != 0));
			printf("\nLine period in ns: \t%d", integrationTime.line_period_in_ns);
		}
		else
		{
			// Error getting the integration time settings from the camera
			printf("\n\nError getting the integration time!\n");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Set the integration time settings
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setIntegrationTimeSettings( void )
{
	if(m_isConnected)
	{
		ULONG tmp;
		CS_INTEGRATION_TIME_STRUCT integrationTime;
		printf("\n\nEnter the integration time settings:");
		printf("\nIntegration time[ns]:\n");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		integrationTime.integration_time_in_ns = tmp;
		// allPIXA wave does not evaluate the line period feature, it is enabled by default
		if(determineCameraType() != ALLPIXA_WAVE)
		{
			printf("Line period feature (0 or 1):\n");
			if(scanf_s("%d", &tmp) <= 0)
				tmp = 0;
			integrationTime.use_line_period_feature = (tmp != 0);
		}
		else
		{
			integrationTime.use_line_period_feature = 1;
		}
		printf("Line period time[ns]:\n");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		integrationTime.line_period_in_ns = tmp;

		if(m_camera->set_integration_time(integrationTime) != CS_OK)
		{
			// Error setting the integration time parameters
			printf("\n\nError setting the integration time!\n");
		}
			 
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}


//////////////////////////////////////////////////////////////////////////
/// Get the currently active image parameters
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getImageParameter( void )
{
	if(m_isConnected)
	{
		CS_IMAGE_PARAMETER_STRUCT imageParameter;
		if(m_camera->get_image_parameters(&imageParameter, true) == CS_OK)
		{
			printf("\n\nFirst scan line delay: \t\t%d", imageParameter.first_scan_line_delay);
			printf("\nImage width: \t\t\t%d", imageParameter.img_width);
			printf("\nImage height: \t\t\t%d", imageParameter.img_height);
		}
		else
		{
			// Error getting the integration time settings from the camera
			printf("Error getting the image parameter!");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Set the image parameters
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setImageParameter( void )
{
	if(m_isConnected)
	{
		INT32 tmp;
		CS_IMAGE_PARAMETER_STRUCT imageParameter;
		printf("\n\nEnter the image parameters:");
		printf("\nFirst scan line delay:\n");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		imageParameter.first_scan_line_delay = tmp;
		printf("Image width:\n");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 100;
		imageParameter.img_width = tmp;
		printf("Image height:\n");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 100;
		imageParameter.img_height = tmp;

		if(m_camera->set_image_parameters(imageParameter) != CS_OK)
		{
			// Error setting the integration time parameters
			printf("\n\nError setting the image parameter!\n");
		}

	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Sends a given HSI file to the camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::sendHSIFile( void )
{
	if(m_isConnected)
	{
		char fileName[MAX_PATH];
		printf("\nPlease enter the HSI file to load(including path):\n");
		if(scanf_s("%s", fileName, MAX_PATH) <= 0)
		{
			printf("Error entering file !")	;
		}

		int nErrorNo = 0;
		if((nErrorNo = m_camera->send_hsi_file_2_camera(fileName)) != CS_OK)
		{
			// Error sending hsi-file
			printf("sending the HSI-file failed!\n");
			char* pErrTxt;

			m_camera->get_error_text(nErrorNo,&pErrTxt);
			if(pErrTxt)
			{
				int color = FOREGROUND_RED|FOREGROUND_INTENSITY;
				textattr(color);
				printf("ErrorNo: %d Text: %s",nErrorNo, pErrTxt);
				printf("\nPlease enter key to continue");
				_getch();
			}

		}

	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Sends a given HSI file list to the camera (e.g. Firmware update)
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::sendFileList2Camera( void )
{
	if(m_isConnected)
	{
		char fileName[MAX_PATH];
		bool displayList = false;
		printf("\nPlease enter the list file to load(including path):\n");
		if(scanf_s("%s", fileName, MAX_PATH) <= 0)
		{
			printf("Error entering file !")	;
		}
		printf("Do you want to display a list dialog when downloading the file list (y/n)?");
		int choice = _getch();
		if(choice == 'y')
			displayList = true;

		int nErrorNo = 0;
		if((nErrorNo = m_camera->send_filelist_2_camera(fileName, displayList)) != CS_OK)
		{
			// Error sending hsi-file
			printf("sending the list failed!\n");
			char* pErrTxt;

			m_camera->get_error_text(nErrorNo,&pErrTxt);
			if(pErrTxt)
			{
				int color = FOREGROUND_RED|FOREGROUND_INTENSITY;
				textattr(color);
				printf("ErrorNo: %d Text: %s",nErrorNo, pErrTxt);
				printf("\nPlease enter key to continue");
				_getch();
			}

		}
		printf("\nDone\n");

	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}


//////////////////////////////////////////////////////////////////////////
/// A reference image will be loaded into the API and valid reference data will be computed from this image 
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::calculateReference(void)
{
	if(m_isConnected)
	{
		INT32 tmp;
		CS_CALCULATE_REFERENCE_STRUCT calcRefParams;
		printf("\n\nEnter the parameters for the reference calculation:");
		printf("\nWhat kind of reference do you want to generate \n(0 = offset reference, 1 = shading reference)?\n\n");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		if(tmp > SHADING_CORRECTION)
		{
			printf("Wrong parameter entered, only 0 or 1 is valid !");
			return;
		}
		calcRefParams.referenceType = (CS_REFERENCE_MODE)tmp;

		// Check if the given image can be loaded for reference generation
		char fileName[MAX_PATH];
		bool bTry2Load = true;
		CImage referenceImage;
		while(bTry2Load)
		{
			printf("\nEnter the path and name for the reference image:\n");
			if(scanf_s("%s", fileName, MAX_PATH) <= 0)
			{
				printf("Error entering file !")	;
			}
			else{
				// Try to load the image
				HRESULT res = referenceImage.Load(CString(fileName));
				if(res != S_OK)
				{
					printf("Loading of the image failed, do you want to try again (y/n)?");
					int choice = _getch();
					if(choice != 'y')
						return;
				}
				else
				{
					printf("\nSuccessfully loaded image with height:%d width %d \nLine pitch(if image is bottom up, this is negative): %d\n", referenceImage.GetHeight(), referenceImage.GetWidth(), referenceImage.GetPitch());
					bTry2Load = false;
				}
			}
		}
		calcRefParams.width = referenceImage.GetWidth() ;
		calcRefParams.height = referenceImage.GetHeight();
		calcRefParams.linePitch = referenceImage.GetPitch();
		calcRefParams.pixelPitch = referenceImage.GetBPP()/8;
		if(calcRefParams.pixelPitch < 3)
			calcRefParams.pixelPitch = 1;
		calcRefParams.pixelFormat = BGR; // CImage uses always BGR 
		calcRefParams.pImage = (BYTE*)referenceImage.GetBits();

		printf("Enter the ID of the reference (0-3):\n");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		if(tmp < 0 || tmp > 3)
		{
			printf("Wrong number entered, setting the reference ID to 0!");
			tmp = 0;
		}
		calcRefParams.referenceNo = tmp ;

		if (calcRefParams.referenceType == SHADING_CORRECTION)
		{
			printf("Target value in 8 bit(default 255):\n");
			if(scanf_s("%d", &tmp) <= 0)
				tmp = 0;
			if(tmp < 50 || tmp > 255)
			{
				printf("Wrong number entered, setting the default value(255)!");
				tmp = 255;
			}
			calcRefParams.targetValue = tmp ;

		}

		// Only do this if it is an allPIXA wave camera
		if(determineCameraType() == ALLPIXA_WAVE)
		{
			calcRefParams.referenceVersion = CS_ALLPIXA_WAVE_VERSION;

			printf("Enter the ID of the color plane (Only important if this is a single color image):\n");
			printf("Red plane:\t%d\n", RED_REF_PLANE);
			printf("Green plane:\t%d\n", GREEN_REF_PLANE);
			printf("Blue plane:\t%d\n", BLUE_REF_PLANE);
			printf("Monochrome plane:\t%d\n", MONOCHROME_REF_PLANE);
			if(scanf_s("%d", &tmp) <= 0)
				tmp = 0;
			if(tmp < 0 || tmp > 4)
			{
				printf("Wrong number entered, setting the reference ID to MONOCHROME_PLANE!");
				tmp = MONOCHROME_REF_PLANE;
			}
			calcRefParams.referenceNo = tmp ;

			// Get information regarding the set ROIs
			printf("\nDo you want to enter the ROI settings manually (0=no,1=yes)? \n");
			if(scanf_s("%d", &tmp) <= 0)
				tmp = 0;
			if(tmp != 1)
			{
				// Retrieve ROI-Information from the camera
				CS_ROI_PARAMETER_STRUCT roiParams;
				if(m_camera->get_roi_parameters(&roiParams, false) != CS_OK)
				{
					printf("Error retrieving ROI parameters from camera!\nTry setting this manually.");
					return;
				}

				for(int i = 0; i < MAX_ROIS; i++)
				{
					calcRefParams.roiParameters.roi_active[i] = roiParams.roi_active[i];
					calcRefParams.roiParameters.roi_start[i] = roiParams.roi_start[i];
					calcRefParams.roiParameters.roi_width[i] = roiParams.roi_width[i];
				}

			}
			else
			{
				// Ask user to enter the required ROI-information
				int noOfROIs=-1;
				while((noOfROIs < 0) || (noOfROIs > MAX_ROIS)){
					printf("Enter the number of ROIs(max. 4):\n");
					noOfROIs = scanf_s("%d", &tmp);
					if(( noOfROIs < 0) || ( noOfROIs >MAX_ROIS))
						tmp = 0;
					if(tmp < 0 || tmp > MAX_ROIS)
					{
						printf("Wrong number entered, setting the reference ID to 0!");
						tmp = 0;
					}
				}
				// Fill the ROIs
				for(int i = 0; i < noOfROIs; i++)
				{
					calcRefParams.roiParameters.roi_active[i]=true;
					// Ask for start position and width
					printf("Start of ROI No. %d\n", i+1);
					if(scanf_s("%d", &tmp) <= 0)
						tmp = 1;
					calcRefParams.roiParameters.roi_start[i] = tmp ;
					printf("Width of ROI No. %d\n", i+1);
					if(scanf_s("%d", &tmp) <= 0)
						tmp = 1;
					calcRefParams.roiParameters.roi_width[i] = tmp ;

				}
				// Disable all other ROIs
				for(int i = noOfROIs; i < MAX_ROIS; i++)
					calcRefParams.roiParameters.roi_active[i]=false;
			}
		}
		
		printf("Enter the path and name where the reference-file should be saved to:\nIf you do not want to save the file press enter.\n");
		// Need to clear the keyboard buffer by calling the gets-function
		gets_s(fileName, MAX_PATH);
		//if(scanf_s("%s", fileName, MAX_PATH) <= 0)
		if(gets_s(fileName, MAX_PATH) == NULL)
		{
			//printf("Error entering file !")	;
			calcRefParams.pFileName = NULL;
		}
		else
		{
			if(strlen(fileName)>0)
				calcRefParams.pFileName = fileName;
			else
				calcRefParams.pFileName = NULL;
		}


		printf("Do you want to send the reference to the camera (0=no,1=yes)?\n");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		calcRefParams.bSend2Camera = tmp != 0;
//////////////////////////////////////////////////////////////////////////
// Automatic calculation of the reference settings is not implemented yet
// Will be realized in the future, please set the parameter manually!
//////////////////////////////////////////////////////////////////////////
// 		printf("\nDo you want to calculate the reference automatically (0=no,1=yes)?\n");
// 		scanf_s("%d", &tmp);
// 		if(tmp == 1 )
// 			tmp = AUTOMATIC_DETECTION;
// 		else
// 			tmp = MANUAL_SETTING;
// 		calcRefParams.calculationMode = (CS_CALC_REFERENCE_MODE)tmp;
		calcRefParams.calculationMode = MANUAL_SETTING;
		//////////////////////////////////////////////////////////////////////////
		// Manual setting of the reference area
		//////////////////////////////////////////////////////////////////////////
		if(calcRefParams.calculationMode != AUTOMATIC_DETECTION)
		{
			printf("Enter the number of lines for the reference calculation\n");
			if(scanf_s("%d", &tmp) <= 0)
				tmp = 0;
			calcRefParams.numberOfLines = tmp ;
			printf("Enter the first line for the calculation:\n");
			if(scanf_s("%d", &tmp) <= 0)
				tmp = 0;
			calcRefParams.topLine = tmp ;
			printf("do you want to use extrapolation (0=no,1=yes)?\n");
			if(scanf_s("%d", &tmp) <= 0)
				tmp = 0;
			calcRefParams.doExtrapolation = (tmp == 1);

			//////////////////////////////////////////////////////////////////////////
			// Get the parameters for the extrapolation
			//////////////////////////////////////////////////////////////////////////
			if(calcRefParams.doExtrapolation )
			{
				printf("Start of the extrapolation left\n");
				if(scanf_s("%d", &tmp) <= 0)
					tmp = 0;
				calcRefParams.leftExtrapolationStart = tmp ;
				printf("Start of the extrapolation right\n");
				if(scanf_s("%d", &tmp) <= 0)
					tmp = 0;
				calcRefParams.rightExtrapolationStart = tmp ;
				printf("Number of columns for the extrapolation ?\n");
				if(scanf_s("%d", &tmp) <= 0)
					tmp = 0;
				calcRefParams.numberOfColumnsForExtrapolation = tmp ;
			}
		}

		if(m_camera->calculate_reference(calcRefParams) != CS_OK)
		{
			// Error calculating the reference
			printf("\n\nError calculating the reference!");
		}

	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Get the currently active properties for camLink connection
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getCamLinkProps( void )
{
	if(m_isConnected)
	{
        CS_CAMLINK_PROPERTIES camLinkProps;
		if(m_camera->get_camLink_properties (&camLinkProps, true) == CS_OK)
		{
            printf("\n\nCamlink-Mode: %d", camLinkProps.camLinkMode);
			if(determineCameraType() != ALLPIXA_WAVE)
			{
				switch (camLinkProps.camLinkMode)
				{
				case CL_BASE_MODE:
					printf(" Base mode");
					break;
				case CL_MEDIUM_MODE:
					printf(" Medium mode");
					break;
				case CL_MEDIUM_MODE_1X2:
					printf(" Medium 1X2 mode");
					break;
				case CL_FULL64_1X8_RAW:
					printf(" Full 64 1X8 raw mode");
					break;
				case CL_FULL80_1X8:
					printf(" Full 80 1X8 mode");
					break;
				case CL_FULL80_1X10:
					printf(" Full 80 1X10 mode");
					break;
				default: 
					printf(" Unknown CL-mode");
					break;
				}
				printf("\nCamlink-Speed: %d", camLinkProps.camLinkSpeed);
			}
			else
			{
				switch (camLinkProps.camLinkMode)
				{
				case CL_BASE_MODE_WAVE:
					printf(" Base mode");
					break;
				case CL_MEDIUM_1X4_MONO_WAVE:
					printf(" Medium mono 1x4 mode");
					break;
				case CL_MEDIUM_1X4_4T_12BIT_MONO_WAVE:
					printf(" Medium mono 1x4 12bit mode");
					break;
				case CL_MEDIUM_1X2_2T_8BIT_RGB_WAVE:
					printf(" Medium rgb 1x2 mode");
					break;
				case CL_MEDIUM_1X4_1T_12BIT_RGB_WAVE:
					printf(" Medium rgb 1x4 12bit mode");
					break;
				case CL_FULL64_1X8_8T_8BIT_RAW_WAVE:
					printf(" Full 64 1X8 raw mode");
					break;
				case CL_FULL80_1X10_10T_8BIT_RAW_WAVE:
					printf(" Full 80 1X10 raw mode");
					break;
				case CL_FULL80_1X8_8T_10BIT_RAW_WAVE:
					printf(" Full 80 1X8 10bit raw mode");
					break;
				default: 
					printf(" Unknown CL-mode");
					break;
				}
			}
		}
		else
		{
            printf("\n\nError getting CamLink properties from the camera");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Set the properties for camLink connection
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setCamLinkProps( void )
{
	INT32 tmp=0; // Buffer variable because scanf is using 32 Bit values!

    if(m_isConnected)
	{
        CS_CAMLINK_PROPERTIES camLinkProps;
		INT16 nError = m_camera->get_camLink_properties (&camLinkProps, true) ;
		if(nError == CS_OK)
		{
			if(determineCameraType() != ALLPIXA_WAVE)
				printf("\n\nPlease select CamLink-Mode \n0 = Base\n1 = Medium (2XE geometry)\n2 = Medium (1X2 (allPIXA pro) geometry or 1x4 if allPIXA pro Mono is used)\n3 = Full 64 (1X8 geometry, only allPIXA pro)\n4 = Full 80 (1X8 geometry, only allPIXA pro)\n5 = Full 80 (1X10 geometry, only allPIXA pro)\n");
			else
				printf("\n\nPlease select CamLink-Mode \n0 = Base\n1 = Medium mono (1x4 geometry)\n2 = Medium (1X4, 12bit geometry)\n3 = Medium (1X2 geometry)\n4 = Medium (1X4, 12bit geometry)\n5 = Full 64 raw(1X8 geometry)\n6 = Full 80 raw(1X10 geometry)\n7 = Full 80 raw(1X8 geometry)\n");
		}
		else
		{
			char *pErrorTxt;
			m_camera->get_error_text(nError, &pErrorTxt);
			printf ("Error setting the cameraLink properties %d\nError description: $s", nError, pErrorTxt);
			return;
		}
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
        camLinkProps.camLinkMode = (CS_CAMLINK_MODE) tmp;
        
		if(determineCameraType() != ALLPIXA_WAVE)
		{
			printf("Please select CamLink-Speed (0=Standard, 1=HighSpeed or 2=ReducedSpeed): ");
			if(scanf_s("%d", &tmp) <= 0)
				tmp = 0;
			camLinkProps.camLinkSpeed = (CS_CAMLINK_SPEED) tmp;
		}
        
        nError = m_camera->set_camLink_properties (camLinkProps);
		if( nError != CS_OK)
		{
			char *pErrorTxt;
			m_camera->get_error_text(nError, &pErrorTxt);
			printf ("Error setting the cameraLink properties %d\nError description: %s", nError, pErrorTxt);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
	printf ("\nDone!");
}


//////////////////////////////////////////////////////////////////////////
/// Get the parameters used for the active references
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getReferenceSettings( void )
{
	if(m_isConnected)
	{
        CS_REFERENCE_PARAMETER_STRUCT RefParamStruct;
		if(m_camera->get_reference_settings (&RefParamStruct, true) == CS_OK)
		{
            printf("\n\nbUseBlackLevelCorrection: %d", RefParamStruct.bUseBlackLevelCorrection);
            printf("\nbUseShadingCorrection: %d", RefParamStruct.bUseShadingCorrection);
            printf("\nnBlackLevelReferenceNo: %d", RefParamStruct.nBlackLevelReferenceNo);
            printf("\nnShadingReferenceNo: %d", RefParamStruct.nShadingReferenceNo);
        }
		else
		{
            printf("\n\nError getting reference settings from camera");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Set the parameters to use for the active references
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setReferenceSettings( void )
{
	INT32 tmp=0; // Buffer variable because scanf is using 32 Bit values!

	if(m_isConnected)
	{
        CS_REFERENCE_PARAMETER_STRUCT RefParamStruct;

        printf("\n\nbUseBlackLevelCorrection (0=no or 1=yes): ");
        if(scanf_s("%d", &tmp) <= 0)
            tmp = 0;
        RefParamStruct.bUseBlackLevelCorrection = (0 !=  tmp);

        printf("bUseShadingCorrection (0=no or 1=yes): ");
        if(scanf_s("%d", &tmp) <= 0)
            tmp = 0;
        RefParamStruct.bUseShadingCorrection = ( 0 != tmp);

        printf("nBlackLevelReferenceNo: ");
        if(scanf_s("%d", &tmp) <= 0)
            tmp = 0;
        RefParamStruct.nBlackLevelReferenceNo = tmp;

        printf("nShadingReferenceNo: ");
        if(scanf_s("%d", &tmp) <= 0)
            tmp = 0;
        RefParamStruct.nShadingReferenceNo = tmp;

        INT16 nError = m_camera->set_reference_settings (RefParamStruct);
        if( nError != CS_OK)
        {
            printf ("Error setting the reference settings in the camera %d\n", nError);
        }
    }
    else
        printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Sets the camera into a mode where a valid image for generating the appropriate reference can  be acquired 
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::prepareCam4Reference( void )
{
	INT32 tmp=0; // Buffer variable because scanf is using 32 Bit values!

	if(m_isConnected)
	{ 
        CS_REFERENCE_MODE referencMode;

		printf("\n\nEnter kind of reference (0 = offset reference, 1 = shading reference): ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
        referencMode = (CS_REFERENCE_MODE) tmp;

        INT16 nError = m_camera->prepare_cam_4reference (referencMode);
        if( nError != CS_OK)
        {
            printf ("Error preparing Camera for Reference, %d\n", nError);
        }        
    }
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Gets the currently active settings for brightness, contrast and gamma correction
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getBrightnessAndContrast( void )
{
	if(m_isConnected)
	{
		CS_BRIGHTNESS_CONTRAST_STRUCT brightnessContrast;
		if(m_camera->get_brightness_and_contrast(&brightnessContrast, true) == CS_OK)
		{
			printf("\n\nUse brightness and contrast: %d", brightnessContrast.useBrightnessAndContrast);
			printf("\nBrightness(red): %d", brightnessContrast.brightness[RED]);
			printf("\nBrightness(green): %d", brightnessContrast.brightness[GREEN]);
			printf("\nBrightness(blue): %d", brightnessContrast.brightness[BLUE]);
			if(determineCameraType() == ALLPIXA_WAVE)
			{
				printf("\nBrightness(white): %d", brightnessContrast.brightness[WHITE]);
			}
			printf("\nContrast(red): %5.3f", brightnessContrast.contrast[RED]);
			printf("\nContrast(green): %5.3f", brightnessContrast.contrast[GREEN]);
			printf("\nContrast(blue): %5.3f", brightnessContrast.contrast[BLUE]);
			if(determineCameraType() == ALLPIXA_WAVE)
			{
				printf("\nContrast(white): %5.3f", brightnessContrast.contrast[WHITE]);
			}
			printf("\nGamma: %5.1f", brightnessContrast.gamma_correction);
		}
		else
		{
			printf("\n\nError getting brightness and contrast settings from camera");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Sets the currently active settings for brightness, contrast and gamma correction
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setBrightnessAndContrast( void )
{
	INT32 tmp=0; // Buffer variable because scanf is using 32 Bit values!

	if(m_isConnected)
	{
		CS_BRIGHTNESS_CONTRAST_STRUCT brightnessContrast;

		printf("\n\nUse brightness and contrast(0=no or 1=yes): ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		brightnessContrast.useBrightnessAndContrast = (0 !=  tmp);

		printf("Brightness (red):\n");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		brightnessContrast.brightness[0] = tmp;
		printf("Brightness (green):\n");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		brightnessContrast.brightness[1] = tmp;
		printf("Brightness (blue):\n");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		brightnessContrast.brightness[2] = tmp;
		if(determineCameraType() == ALLPIXA_WAVE)
		{
			printf("Brightness (white):\n");
			if(scanf_s("%d", &tmp) <= 0)
				tmp = 0;
			brightnessContrast.brightness[WHITE] = tmp;
		}
		printf("Contrast (red):\n");
		float dTmp;
		if(scanf_s("%e", &dTmp) <= 0)
			dTmp = 0.0;
		brightnessContrast.contrast[RED] = dTmp + 0.0005;
		printf("Contrast (green):\n");
		if(scanf_s("%e", &dTmp) <= 0)
			dTmp = 0.0;
		brightnessContrast.contrast[GREEN] = dTmp + 0.0005;
		printf("Contrast (blue):\n");
		if(scanf_s("%e", &dTmp) <= 0)
			dTmp = 0.0;
		brightnessContrast.contrast[BLUE] = dTmp + 0.0005;

		if(determineCameraType() == ALLPIXA_WAVE)
		{
			printf("Contrast (white):\n");
			if(scanf_s("%e", &dTmp) <= 0)
				dTmp = 0.0;
			brightnessContrast.contrast[WHITE] = dTmp + 0.0005;

		}

		printf("Gamma:\n");
		if(scanf_s("%e", &dTmp) <= 0)
			dTmp = 0.0;
		brightnessContrast.gamma_correction = dTmp + 0.05;

		INT16 nError = m_camera->set_brightness_and_contrast(brightnessContrast);
		if( nError != CS_OK)
		{
			printf ("Error setting the brightness and contrast settings in the camera %d\n", nError);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}


//////////////////////////////////////////////////////////////////////////
/// Gets the currently active image processing parameters
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getImageProcessingParameter( void )
{
	if(m_isConnected)
	{
		CS_IMAGE_PROCESSING_PARAMETER_STRUCT imageProcParams;
		if(m_camera->get_image_processing_parameters(&imageProcParams, true) == CS_OK)
		{
			printf("\n\nMirror image: %d", imageProcParams.mirror_image_horizontally);
			printf("\nUse color conversion matrix: %d", imageProcParams.use_color_conversion_matrix);
			printf("\nselect color conversion matrix: %d", imageProcParams.select_color_conversion_matrix);
			
			if(determineCameraType() != ALLPIXA_WAVE)
			{
				// These parameters are currently not supported by the allPIXA wave camera!
				printf("\nUse linearisation table: %d", imageProcParams.use_linearisation_table);
				printf("\nUse keystone correction: %d", imageProcParams.use_keystone_correction);
				printf("\nKeystone pixel shift: %5.1f", imageProcParams.keystone_pixel_shift);
				printf("\nKeystone correction width: %d", imageProcParams.keystone_correction_width);
			}
		}
		else
		{
			printf("\n\nError getting image processing settings from camera");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Sets the currently active image processing parameters
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setImageProcessingParameter( void )
{
	INT32 tmp=0; // Buffer variable because scanf is using 32 Bit values!

	if(m_isConnected)
	{
		CS_IMAGE_PROCESSING_PARAMETER_STRUCT imageProcParams;

		printf("\n\nMirror Image (0=no or 1=yes): ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		imageProcParams.mirror_image_horizontally = (0 !=  tmp);

		if(determineCameraType() != ALLPIXA_WAVE)
		{
			// These parameters are currently not supported by the allPIXA wave camera!
			printf("Use the linearisation table(0=no or 1=yes): ");
			if(scanf_s("%d", &tmp) <= 0)
				tmp = 0;
			imageProcParams.use_linearisation_table = (0 !=  tmp);
			printf("Use keystone correction (0=no or 1=yes): ");
			if(scanf_s("%d", &tmp) <= 0)
				tmp = 0;
			imageProcParams.use_keystone_correction = (0 !=  tmp);
			float dTmp;
			printf("Pixel shift for keystone correction [float]: ");
			if(scanf_s("%e", &dTmp) <= 0)
				dTmp = 0.0;
			imageProcParams.keystone_pixel_shift = dTmp + 0.05;
			printf("Keystone correction correction width [int]: ");
			if(scanf_s("%d", &tmp) <= 0)
				tmp = 0;
			imageProcParams.keystone_correction_width = tmp;
		}

		printf("Use color correction matrix (0=no or 1=yes): ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		imageProcParams.use_color_conversion_matrix = (0 !=  tmp);

		printf("select color conversion matrix: ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		imageProcParams.select_color_conversion_matrix = tmp;

		INT16 nError = m_camera->set_image_processing_parameters(imageProcParams);
		if( nError != CS_OK)
		{
			printf ("Error setting the image processing parameters in the camera %d\n", nError);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Gets the currently active physical setup parameters
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getPhysicalSetupParameter( void )
{
	if(m_isConnected)
	{
		CS_PHYSICAL_SETUP_STRUCT physicalSetup;
		if(m_camera->get_camera_physical_setup (&physicalSetup, true) == CS_OK)
		{
            printf("\n\nRGB line distance: %5.3f", physicalSetup.rgb_line_distance);
            printf("\nScan direction: %d", physicalSetup.scan_direction);
		}
		else
		{
			printf("\n\nError getting physical setup parameter from camera");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Sets the currently active image processing parameters
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setPhysicalSetupParameter( void )
{
	INT32 tmp=0; // Buffer variable because scanf is using 32 Bit values!

	if(m_isConnected)
	{
		CS_PHYSICAL_SETUP_STRUCT physicalSetup;

		float dTmp;
		printf("\n\nRBG line distance : ");
		if(scanf_s("%e", &dTmp) <= 0)
			dTmp = 0.0;
        physicalSetup.rgb_line_distance = (dTmp + 0.005);

        printf("Scan direction (0=forward or 1=backward): ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
        physicalSetup.scan_direction = (0 !=  tmp);
OutputDebugString(_T("set physical setup Parameter"));
		INT16 nError = m_camera->set_camera_physical_setup (physicalSetup);
		if( nError != CS_OK)
		{
			printf ("Error setting physical setup parameters in the camera %d\n", nError);
		}
		OutputDebugString(_T("set physical setup Parameter done"));
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Gets the currently active video output parameters
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getVideoOutputParameter( void )
{
	if(m_isConnected)
	{
		CS_VIDEO_OUTPUT_STRUCT videoOutData;
		if(m_camera->get_video_output_parameters(&videoOutData, true) == CS_OK)
		{
			char outputMode[255];
			if(determineCameraType() != ALLPIXA_WAVE)
			{
				switch(videoOutData.video_output_mode)
				{
				case _3x8_BIT_COLOR_PARALLEL:
					strcpy_s(outputMode, "3x8 Bit RGB in parallel(dual base)");
					break;
				case _2x8_BIT_GREY_FIRST_CL_PORT:
					strcpy_s(outputMode, "2x8 Bit grey on first CL port");
					break;
				case _2x10_BIT_GREY_FIRST_CL_PORT:
					strcpy_s(outputMode, "2*10 bit grey on first CL port");
					break;
				case _2x12_BIT_GREY_FIRST_CL_PORT:
					strcpy_s(outputMode, "2x12 bit grey on first CL port");
					break;
				case _2x8_BIT_GREY_CL_DUAL_BASE:
					strcpy_s(outputMode, "2x8 Bit grey on both CL ports(dual base)");
					break;
				case _2x10_BIT_GREY_CL_DUAL_BASE:
					strcpy_s(outputMode, "2x10 Bit grey on both CL ports(dual base)");
					break;
				case _2x12_BIT_GREY_CL_DUAL_BASE:
					strcpy_s(outputMode, "2x12 Bit grey on both CL ports(dual base)");
					break;
				default:
					strcpy_s(outputMode, "Unknown video output format");

				}
			}
			else
			{
				switch(videoOutData.video_output_mode)
				{
				case COLOR:
					strcpy_s(outputMode, "Grey");
					break;
				case _3X8_BIT_MONO_BASE:
					strcpy_s(outputMode, "3x8 Bit grey base mode");
					break;
				case _4X8_BIT_MONO_MEDIUM:
					strcpy_s(outputMode, "4x8 Bit grey medium mode");
					break;
				case _4X12_BIT_MONO_MEDIUM:
					strcpy_s(outputMode, "4x12 Bit grey medium mode");
					break;
				default:
					strcpy_s(outputMode, "Unknown video output format");

				}
			}
			printf("\n\nVideo output mode: %s", outputMode);
			printf("\nColor weight red: %5.2f", videoOutData.color_weight_red);
			printf("\nColor weight green: %5.2f", videoOutData.color_weight_green);
			printf("\nColor weight blue: %5.2f", videoOutData.color_weight_blue);
			printf("\nSwap color channels (red and blue): %d", videoOutData.swap_color_channels_red_blue);
			printf("\nInsert mode: 0x%x", videoOutData.insert_mode);
			if(determineCameraType() != ALLPIXA_WAVE)
			{
				printf("\nposition each line data: %d", videoOutData.position_eachline_data);
			}
		}
		else
		{
			printf("\n\nError getting video output parameter from camera");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Sets the parameters related to the output format
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setVideoOutputParameter( void )
{
	INT32 tmp=0; // Buffer variable because scanf is using 32 Bit values!

	if(m_isConnected)
	{
		CS_VIDEO_OUTPUT_STRUCT videoOutData;

		printf("\n\nSet the video output mode: ");
		if(determineCameraType() != ALLPIXA_WAVE)
		{
			printf("\n%d = RGB output: ", _3x8_BIT_COLOR_PARALLEL );
			printf("\n%d = 2x8 Bit grey on first CL port", _2x8_BIT_GREY_FIRST_CL_PORT);
			printf("\n%d = 2x10 Bit grey on first CL port", _2x10_BIT_GREY_FIRST_CL_PORT);
			printf("\n%d = 2x12 Bit grey on first CL port", _2x12_BIT_GREY_FIRST_CL_PORT);
			printf("\n%d = 2x8 Bit grey on both CL ports(dual base)", _2x8_BIT_GREY_CL_DUAL_BASE);
			printf("\n%d = 2x10 Bit grey on both CL ports(dual base)", _2x10_BIT_GREY_CL_DUAL_BASE);
			printf("\n%d = 2x12 Bit grey on both CL ports(dual base)\n", _2x12_BIT_GREY_CL_DUAL_BASE);
		}
		else
		{
			printf("\n%d = Color output ", COLOR );
			printf("\n%d = 3x8 Grey output base", _3X8_BIT_MONO_BASE );
			printf("\n%d = 4x8 Grey output medium", _4X8_BIT_MONO_MEDIUM );
			printf("\n%d = 4x12 Grey output medium", _4X12_BIT_MONO_MEDIUM );

		}

		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		videoOutData.video_output_mode = tmp;
		float dTmp;

		printf("Color weight red: ");
		if(scanf_s("%e", &dTmp) <= 0)
			dTmp = 0.0;
		videoOutData.color_weight_red = (float)(dTmp + 0.005);
		printf("Color weight green: ");
		if(scanf_s("%e", &dTmp) <= 0)
			dTmp = 0.0;
		videoOutData.color_weight_green = (float)(dTmp + 0.005);
		printf("Color weight blue: ");
		if(scanf_s("%e", &dTmp) <= 0)
			dTmp = 0.0;
		videoOutData.color_weight_blue = (float)(dTmp + 0.005);

		printf("Swap color channels blue and red(0=no or 1=yes): ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		videoOutData.swap_color_channels_red_blue = tmp != 0;

		printf("Insert mode (in HEX): ");
		if(scanf_s("%x", &tmp) <= 0)
			tmp = 0;
		videoOutData.insert_mode = tmp;

		if(determineCameraType() != ALLPIXA_WAVE)
		{
			printf("position each line data (0=start of line, 1=end of line, 2=start and end): ");
			if(scanf_s("%d", &tmp) <= 0)
				tmp = 0;
			videoOutData.position_eachline_data = tmp;
		}

        INT16 nError = m_camera->set_video_output_parameters(videoOutData);
		if( nError != CS_OK)
		{
			printf ("Error setting the video output parameters in the camera %d\n", nError);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}


//////////////////////////////////////////////////////////////////////////
/// Gets the parameters for the external triggering of the camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getTriggerSettings( void )
{
	if(m_isConnected)
	{
		CS_TRIGGER_STRUCT triggerParams;
		if(m_camera->get_camera_trigger_mode(&triggerParams, true) == CS_OK)
		{
			char text[200];
				
			switch(triggerParams.trigger_mode)
			{
			case FREE_RUNNING:
				strcpy_s(text, "Free running");
				break;
			case START_CONDITION_ONLY:
				strcpy_s(text, "Use start condition");
				break;
			case START_STOP_CONDITION:
				strcpy_s(text, "Use start and stop condition");
				break;
			default:
				strcpy_s(text, "Mode not defined");
			}
			printf("\n\nTrigger mode: \t\t\t\t%s", text);
			printf("\nScan lines after stop: \t\t\t%d", triggerParams.scan_lines_after_stop);
			printf("\nStop after max. number of lines: \t%d", triggerParams.stop_after_max_no_of_scan_lines);
			printf("\nMax. number of scan lines: \t\t%d", triggerParams.max_no_of_scan_lines);
			if(determineCameraType() != ALLPIXA_WAVE)
				printf("\nNo. of suppressed lines: \t\t%d", triggerParams.no_of_suppressed_lines);
			switch(triggerParams.trigger_input)
			{
			case LIGHT_BARRIER_0:
				strcpy_s(text, "Light barrier 0");
				break;
			case LIGHT_BARRIER_1:
				strcpy_s(text, "Light barrier 1");
				break;
			case LIGHT_BARRIER_2:
				strcpy_s(text, "Light barrier 2");
				break;
			case LIGHT_BARRIER_3:
				strcpy_s(text, "Light barrier 3");
				break;
			default:
				strcpy_s(text, "Not defined");
				break;
			}
			printf("\nUsed trigger input: \t\t\t%s", text);
			
			switch(triggerParams.start_condition)
			{
			case RAISING_EDGE:
				strcpy_s(text, "Raising edge");
				break;
			case FALLING_EDGE:
				strcpy_s(text, "Falling edge");
				break;
			default:
				strcpy_s(text, "Not defined");
				break;
			}
			printf("\nStart condition: \t\t\t%s", text);
			switch(triggerParams.stop_condition)
			{
			case RAISING_EDGE:
				strcpy_s(text, "Raising edge");
				break;
			case FALLING_EDGE:
				strcpy_s(text, "Falling edge");
				break;
			default:
				strcpy_s(text, "Not defined");
				break;
			}
			printf("\nStop condition: \t\t\t%s", text);
			switch(triggerParams.master_slave_operation)
			{
			case NO_MASTER_SLAVE_OPERATION:
				strcpy_s(text, "No master slave operation");
				break;
			case CAMERA_IS_MASTER:
				strcpy_s(text, "Camera is master");
				break;
			case CAMERA_IS_SLAVE:
				strcpy_s(text, "Camera is slave");
				break;
			case SELECT_MASTER_SLAVE_BY_INPUT:
				strcpy_s(text, "Master/Slave selected by GPIO");
				break;
			default:
				strcpy_s(text, "Not defined");
				break;
			}
			printf("\nMaster slave operation: \t\t%s", text);
		}
		else
		{
			printf("\n\nError trigger settings from camera");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Sets the parameters for the external triggering of the camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setTriggerSettings( void )
{
	INT32 tmp=0; // Buffer variable because scanf is using 32 Bit values!

	if(m_isConnected)
	{
		CS_TRIGGER_STRUCT triggerParams;

		printf("\nSet the trigger mode: \nFree running: \t\t\t%d\nOnly start condition:\t\t%d\nStart and stop condition:\t%d\n", FREE_RUNNING, START_CONDITION_ONLY, START_STOP_CONDITION);
		if(scanf_s("%d", &tmp) <= 0)
			tmp = FREE_RUNNING;
		triggerParams.trigger_mode = tmp;
		printf("\nScan lines after stop: ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		triggerParams.scan_lines_after_stop = tmp;
		printf("\nStop after max. number of lines (0: do not stop, 1: stop): ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		triggerParams.stop_after_max_no_of_scan_lines = (tmp != 0);
		printf("\nMax. number of scan lines: ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		triggerParams.max_no_of_scan_lines = tmp;
		if(determineCameraType() != ALLPIXA_WAVE)
		{
			printf("No. of suppressed lines:\n");
			if(scanf_s("%d", &tmp) <= 0)
				tmp = 0;
			triggerParams.no_of_suppressed_lines = tmp;
		}
		printf("\nTrigger Input (Light barrier 0= %d, LB1=%d, LB2=%d LB3=%d)",LIGHT_BARRIER_0,LIGHT_BARRIER_1,LIGHT_BARRIER_2,LIGHT_BARRIER_3 );
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		triggerParams.trigger_input = tmp;
		printf("\nStart Condition (Raising edge = %d, falling edge = %d)", RAISING_EDGE, FALLING_EDGE);
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		triggerParams.start_condition = tmp;
		printf("\nStop Condition (Raising edge = %d, falling edge = %d)", RAISING_EDGE, FALLING_EDGE);
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		triggerParams.stop_condition = tmp;
		printf("\nMaster/slave setting (No master slave operation= %d\nCamera is master=%d\nCamera is slave=%d\nMaster slave selected by GPIO=%d)\n",NO_MASTER_SLAVE_OPERATION,CAMERA_IS_MASTER,CAMERA_IS_SLAVE,SELECT_MASTER_SLAVE_BY_INPUT );
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		triggerParams.master_slave_operation = tmp;

		INT16 nError = m_camera->set_camera_trigger_mode(triggerParams);
		if( nError != CS_OK)
		{
			printf ("Error setting the trigger mode in the camera %d\n", nError);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}


//////////////////////////////////////////////////////////////////////////
/// Gets the parameters for internal light barrier of the camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getInternalLightBarrierSettings( void )
{
	if(m_isConnected)
	{
		CS_INTERNAL_LIGHT_BARRIER_STRUCT lightBarrierParams;
		if(m_camera->get_internal_light_barrier_settings(&lightBarrierParams, true) == CS_OK)
		{
			char text[200];

			printf("\n\nROI start: \t\t", lightBarrierParams.roi_start);
			switch(lightBarrierParams.roi_length)
			{
			case INTERNAL_LIGHT_BARRIER_ROI_LENGTH_32P:
				strcpy_s(text, "32 Lines");
				break;
			case INTERNAL_LIGHT_BARRIER_ROI_LENGTH_64P:
				strcpy_s(text, "64 Lines");
				break;
			case INTERNAL_LIGHT_BARRIER_ROI_LENGTH_128P:
				strcpy_s(text, "128 Lines");
				break;
			case INTERNAL_LIGHT_BARRIER_ROI_LENGTH_256P:
				strcpy_s(text, "256 Lines");
				break;
			default:
				strcpy_s(text, "length not defined");
			}
			printf("\nROI length: \t\t\t%s", text);
			printf("\nDisplay ROI in the image: \t\t%d", lightBarrierParams.mark_roi_in_image);
			switch(lightBarrierParams.color_selection_for_edge_detection)
			{
			case INTERNAL_LIGHT_BARRIER_ALL_COLORS:
				strcpy_s(text, "All colors");
				break;
			case INTERNAL_LIGHT_BARRIER_RED_COLOR:
				strcpy_s(text, "All colors");
				break;
			case INTERNAL_LIGHT_BARRIER_GREEN_COLOR:
				strcpy_s(text, "All colors");
				break;
			case INTERNAL_LIGHT_BARRIER_BLUE_COLOR:
				strcpy_s(text, "All colors");
				break;
			default:
				strcpy_s(text, "Not defined");
				break;
			}
			printf("\nUsed color channels for trigger: \t\t\t%s", text);
			printf("\nBrightness level for rising edge: \t\t%d", lightBarrierParams.rising_edge_level);
			printf("\nBrightness level for falling edge: \t\t%d", lightBarrierParams.falling_edge_level);

		}
		else
		{
			printf("\n\nError reading internal light barrier settings from camera");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Sets the parameters for the internal light barrier of the camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setInternalLightBarrierSettings( void )
{
	INT32 tmp=0; // Buffer variable because scanf is using 32 Bit values!

	if(m_isConnected)
	{
		CS_INTERNAL_LIGHT_BARRIER_STRUCT lightBarrierParams;

		int tmp;
		printf("\nStart of the ROI: ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		lightBarrierParams.roi_start = tmp;

		printf("\nSet the length of the ROI: \n32 Lines: \t%d\n\n64 Lines: \t%d\n\n128 Lines: \t%d\n\n256 Lines: \t%d\n", INTERNAL_LIGHT_BARRIER_ROI_LENGTH_32P, INTERNAL_LIGHT_BARRIER_ROI_LENGTH_64P, INTERNAL_LIGHT_BARRIER_ROI_LENGTH_128P, INTERNAL_LIGHT_BARRIER_ROI_LENGTH_256P);
		if(scanf_s("%d", &tmp) <= 0)
			tmp = INTERNAL_LIGHT_BARRIER_ROI_LENGTH_32P;
		lightBarrierParams.roi_length = tmp;

		printf("\nDisplay ROI in the image (0 or 1): ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		lightBarrierParams.mark_roi_in_image;
		
		printf("\nSet the used color channels: \nAll channels: \t%d\n\nRed Channel: \t%d\n\nGreen channel: \t%d\n\nBlue channel: \t%d\n"
			, INTERNAL_LIGHT_BARRIER_ALL_COLORS, INTERNAL_LIGHT_BARRIER_RED_COLOR, INTERNAL_LIGHT_BARRIER_GREEN_COLOR, INTERNAL_LIGHT_BARRIER_BLUE_COLOR);
		if(scanf_s("%d", &tmp) <= 0)
			tmp = INTERNAL_LIGHT_BARRIER_ALL_COLORS;
		lightBarrierParams.color_selection_for_edge_detection = tmp;

		printf("\nBrightness level for rising edge (0-255): ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		lightBarrierParams.rising_edge_level;

		printf("\nBrightness level for falling edge (0-255): ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		lightBarrierParams.falling_edge_level;

		INT16 nError = m_camera->set_internal_light_barrier_settings(lightBarrierParams);
		if( nError != CS_OK)
		{
			printf ("Error setting the internal light barrier parameters in the camera %d\n", nError);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}
//////////////////////////////////////////////////////////////////////////
/// Sets the parameters for the encoder mode of the camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setEncoderParameters( void )
{
	INT32 tmp=0; // Buffer variable because scanf is using 32 Bit values!
	float fTmp=0;

	if(m_isConnected)
	{
		CS_ENCODER_STRUCT encoderSettings;

		printf("\n\nUse Encoder(0=no or 1=yes): ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		encoderSettings.enable_ecoder = (0 !=  tmp);

		printf("Increments per um:\n");
		if(scanf_s("%e", &fTmp) <= 0)
			fTmp = 0.0;
		encoderSettings.um_per_increment = fTmp + 0.0005;

		printf("\nNumber of encoder channels: ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		encoderSettings.encoder_channels = tmp;

		printf("\nLine trigger reduction: ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		encoderSettings.line_trigger_reduction = tmp;

		printf("\nVertical resolution in DPI: ");
		if(scanf_s("%e", &fTmp) <= 0)
			fTmp = 0.0;
		encoderSettings.vertical_resolution_dpi = fTmp + 0.0005;

		printf("\nSynchronisation mode (Standard encoder: %d, Line Trigger: %d)", STANDARD_ENCODER, LINE_TRIGGER);
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		encoderSettings.synchronisation_mode = tmp;

		printf("Enter the number of encoder pulses to average (0, 2, 4, 8 or 16): ");
		if(scanf_s("%d", &tmp) <= 0)
			encoderSettings.averaging = NO_AVERAGING;
		else{
			switch(tmp)
			{
			case 0:
				encoderSettings.averaging = NO_AVERAGING;
				break;
			case 2:
				encoderSettings.averaging = USE_2_SAMPLES_FOR_AVERAGING;
				break;
			case 4:
				encoderSettings.averaging = USE_4_SAMPLES_FOR_AVERAGING;
				break;
			case 8:
				encoderSettings.averaging = USE_8_SAMPLES_FOR_AVERAGING;
				break;
			case 16:
				encoderSettings.averaging = USE_16_SAMPLES_FOR_AVERAGING;
				break;
			default:
				encoderSettings.averaging = NO_AVERAGING;
				break;
			}
		}

		INT16 nError = m_camera->set_encoder_parameters(encoderSettings,true);
		if( nError != CS_OK)
		{
			printf ("Error setting the encoder parameters in the camera %d\n", nError);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Gets the currently active parameters for the encoder mode of the camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getEncoderParameters( void )
{
	if(m_isConnected)
	{
		CS_ENCODER_STRUCT encoderSettings;
		if(m_camera->get_encoder_parameters(&encoderSettings, true) == CS_OK)
		{
			printf("\n\nEncoder enabled: \t\t%d", encoderSettings.enable_ecoder);
			printf("\nIncrements per um: \t\t%5.3f", encoderSettings.um_per_increment);
			printf("\nNumber of encoder channels: \t%d", encoderSettings.encoder_channels);
			printf("\nLine trigger reduction: \t%d", encoderSettings.line_trigger_reduction);
			printf("\nVertical resolution: \t\t%5.3f DPI", encoderSettings.vertical_resolution_dpi);
			char buffer[200];
			switch(encoderSettings.synchronisation_mode)
			{
			case STANDARD_ENCODER:
				strcpy_s(buffer, 200,  "STANDARD_ENCODER");
				break;
			case LINE_TRIGGER:
				strcpy_s(buffer, 200,  "LINE_TRIGGER");
				break;
			default:
				strcpy_s(buffer, 200,  "Unknown sync mode");
				break;
			}
			printf("\nSynchronization mode: \t\t%s", buffer);
			printf("\nAveraging: \t\t\t%d", (int)(pow(2.0, encoderSettings.averaging)));
		}
		else
		{
			printf("\n\nError getting encoder parameters from camera");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Gets the currently active IO configuration parameters
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getIOConfigurationParameter( void )
{
	if(m_isConnected)
	{
		CS_IO_CONFIG_STRUCT IOConfig;
		if(m_camera->get_IO_signal_configuration (&IOConfig, true) == CS_OK)
		{
            printf("\n\nEncoder Config: 0x%x", IOConfig.encoder_config);
            printf("\nINCR0: 0x%x", IOConfig.encoder_incr0);
            printf("\nINCR1: 0x%x", IOConfig.encoder_incr1);
			printf("\nLight barrier: 0x%x", IOConfig.light_barrier);
			printf("\nSelect master: 0x%x", IOConfig.select_master);
			printf("\nMaster/Slave interface: 0x%x", IOConfig.master_slave_interface);
            printf("\nGeneral function: 0x%x", IOConfig.general_functions);
		}
		else
		{
			printf("\n\nError getting IO Config parameter from camera");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Sets the currently active IO configuration parameters
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setIOConfigurationParameter( void )
{
	INT32 tmp=0; // Buffer variable because scanf is using 32 Bit values!

	if(m_isConnected)
	{
		CS_IO_CONFIG_STRUCT IOConfig;

		printf("\n\nEncoder Config: ");
		if(scanf_s("%x", &tmp) <= 0)
			tmp = 0;
        IOConfig.encoder_config = (UINT16) tmp;

        printf("INCR0: ");
		if(scanf_s("%x", &tmp) <= 0)
			tmp = 0;
        IOConfig.encoder_incr0 = (UINT16) tmp;

        printf("INCR1: ");
		if(scanf_s("%x", &tmp) <= 0)
			tmp = 0;
        IOConfig.encoder_incr1 = (UINT16) tmp;

        printf("Light barrier: ");
		if(scanf_s("%x", &tmp) <= 0)
			tmp = 0;
        IOConfig.light_barrier = (UINT16) tmp;

		printf("Select master: ");
		if(scanf_s("%x", &tmp) <= 0)
			tmp = 0;
		IOConfig.select_master = (UINT16) tmp;
        
		printf("Master/Slave interface: ");
		if(scanf_s("%x", &tmp) <= 0)
			tmp = 0;
		IOConfig.master_slave_interface = (UINT16) tmp;

		printf("General functions: ");
		if(scanf_s("%x", &tmp) <= 0)
			tmp = 0;
        IOConfig.general_functions = (UINT16) tmp;

        INT16 nError = m_camera->set_IO_signal_configuration (IOConfig);
		if( nError != CS_OK)
		{
			printf ("Error setting IO configuration parameters in the camera %d\n", nError);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Gets the operational values of the camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::get_camera_operating_values (void)
{
	if(m_isConnected)
	{
        CS_CAMERA_OPERATING_VALUES_STRUCT operatingValues;
        if(m_camera->get_camera_operating_values (&operatingValues) == CS_OK)
		{
			printf("\n\nInput state: 0x%x", operatingValues.inputStatus);
			printf("\ngain control disable state: 0x%x", operatingValues.gainCtrlDisableState);
			printf("\nimage count: %d", operatingValues.imageCount);
			if(determineCameraType() != ALLPIXA_WAVE)
			{
				printf("\ncurrent wref values:");
				printf("\nRO:      %d, RE:         %d", operatingValues.nCurrentWhiteRef[RED_ODD], operatingValues.nCurrentWhiteRef[RED_EVEN]);
				printf("\nGO_REAR: %d, RE_REAR:    %d", operatingValues.nCurrentWhiteRef[RED_ODD_REAR], operatingValues.nCurrentWhiteRef[RED_EVEN_REAR]);
				printf("\nGO:      %d, GE:         %d", operatingValues.nCurrentWhiteRef[GREEN_ODD], operatingValues.nCurrentWhiteRef[GREEN_EVEN]);
				printf("\nGO_REAR: %d, GE_REAR:    %d", operatingValues.nCurrentWhiteRef[GREEN_ODD_REAR], operatingValues.nCurrentWhiteRef[GREEN_EVEN_REAR]);
				printf("\nBO:      %d, BE:         %d", operatingValues.nCurrentWhiteRef[BLUE_ODD], operatingValues.nCurrentWhiteRef[BLUE_EVEN]);
				printf("\nBO_REAR: %d, BE_REAR:    %d", operatingValues.nCurrentWhiteRef[BLUE_ODD_REAR], operatingValues.nCurrentWhiteRef[BLUE_EVEN_REAR]);
				printf("\ncurrent gain values:");
				printf("\nRO:      %d, RE:         %d", operatingValues.nCurrentGain[RED_ODD], operatingValues.nCurrentGain[RED_EVEN]);
				printf("\nGO_REAR: %d, RE_REAR:    %d", operatingValues.nCurrentGain[RED_ODD_REAR], operatingValues.nCurrentGain[RED_EVEN_REAR]);
				printf("\nGO:      %d, GE:         %d", operatingValues.nCurrentGain[GREEN_ODD], operatingValues.nCurrentGain[GREEN_EVEN]);
				printf("\nGO_REAR: %d, GE_REAR:    %d", operatingValues.nCurrentGain[GREEN_ODD_REAR], operatingValues.nCurrentGain[GREEN_EVEN_REAR]);
				printf("\nBO:      %d, BE:         %d", operatingValues.nCurrentGain[BLUE_ODD], operatingValues.nCurrentGain[BLUE_EVEN]);
				printf("\nBO_REAR: %d, BE_REAR:    %d", operatingValues.nCurrentGain[BLUE_ODD_REAR], operatingValues.nCurrentGain[BLUE_EVEN_REAR]);
				printf("\nanalog1:   %d", operatingValues.internalVoltage[0]);
				printf("\nanalog2:   %d", operatingValues.internalVoltage[1]);
				printf("\nVcore:     %d", operatingValues.internalVoltage[2]);
				printf("\nsupply1:   %d", operatingValues.internalVoltage[3]);
				printf("\nsupply2:   %d", operatingValues.internalVoltage[4]);
				printf("\nsupplyCCD: %d", operatingValues.internalVoltage[5]);
			}
			else
			{
				printf("\ncurrent wref values:");
				printf("\nRed:\t%d", operatingValues.nCurrentWhiteRef[RED]);
				printf("\nGreen:\t%d", operatingValues.nCurrentWhiteRef[GREEN]);
				printf("\nBlue:\t%d", operatingValues.nCurrentWhiteRef[BLUE]);
				printf("\nWhite:\t%d", operatingValues.nCurrentWhiteRef[WHITE]);
				printf("\ncurrent gain values:");
				printf("\nRed:\t%5.3f", operatingValues.nCurrentGain[RED]/1000.0);
				printf("\nGreen:\t%5.3f", operatingValues.nCurrentGain[GREEN]/1000.0);
				printf("\nBlue:\t%5.3f", operatingValues.nCurrentGain[BLUE]/1000.0);
				printf("\nWhite:\t%5.3f", operatingValues.nCurrentGain[WHITE]/1000.0);
				printf("\nInternal 1:   %d", operatingValues.internalVoltage[0]);
				printf("\nInternal 2:   %d", operatingValues.internalVoltage[1]);
				printf("\nInternal 3:   %d", operatingValues.internalVoltage[2]);
				printf("\nInternal 4:   %d", operatingValues.internalVoltage[3]);
				printf("\nInternal 5:   %d", operatingValues.internalVoltage[4]);
			}
			printf("\nsync integration time: %d", operatingValues.syncIntegrationTime);
			printf("\ncamera state: 0x%x", operatingValues.cameraState);
			printf("\nerror state: 0x%x", operatingValues.errorState);
			printf("\nled state: 0x%x", operatingValues.ledState);
			
			if(operatingValues.currentTransportSpeed == SPEED_2_HIGH)
				printf("\ntransport speed: %7.2f -> too high", operatingValues.currentTransportSpeed);
			else if(operatingValues.currentTransportSpeed == SPEED_2_SLOW)
				printf("\ntransport speed: %7.2f -> too slow", operatingValues.currentTransportSpeed);
			else
				printf("\ntransport speed: %7.2f", operatingValues.currentTransportSpeed);
			printf("\nLedVoltage_0: %d", operatingValues.voltageLed[0]);
			printf("\nLedVoltage_1: %d", operatingValues.voltageLed[1]);
			printf("\nLedVoltage_2: %d", operatingValues.voltageLed[2]);
			printf("\nLedVoltage_3: %d", operatingValues.voltageLed[3]);
			printf("\nLedVoltage_4: %d", operatingValues.voltageLed[4]);
			printf("\nInput Voltage: %d", operatingValues.inputVoltage);
			printf("\ntemperature board: %i", operatingValues.temperatureBoard);
			printf("\ntemperature led controller: %i", operatingValues.temperatureLEDController);
			printf("\ntemperature sensor: %i", operatingValues.temperatureSensor);
			printf("\ntemperature led: %i", operatingValues.temperatureLed);

			char masterSlave[40];
			switch(operatingValues.masterSlaveMode)
			{
			case NO_MASTER_SLAVE_OPERATION:
				strcpy_s(masterSlave, "No master slave operation");
				break;
			case CAMERA_IS_MASTER:
				strcpy_s(masterSlave, "Camera is master");
				break;
			case CAMERA_IS_SLAVE:
				strcpy_s(masterSlave, "Camera is slave");
				break;
			default:
				strcpy_s(masterSlave, "Undefined master/slave mode");
				break;
			}
			printf("\nMaster-Slave mode: %s", masterSlave);
        }
		else
		{
			printf("\n\nError getting operation values from camera");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// autodetect all connected cameras and list their details nad connection info
//////////////////////////////////////////////////////////////////////////

void CChromasensApiCalls::autoDetectCameras (void)
{
	if(m_camera != NULL) {
		printf("\n\nOn which interfaces do you want to search for connected cameras?");
		printf("\nOnly CameraLink(1), Only RS232(2) or on both interfaces(3)?");
		int tmp;
		if(scanf_s("%d", &tmp) < 1)
			tmp = 3;
		if(tmp > 3)
			tmp = 3;
		bool bSearchOnCL = false;
		bool bSearchOnRS232 = false;
		if((tmp == 2) || (tmp == 3))
			bSearchOnRS232 = true;
		if((tmp == 1) || (tmp == 3))
			bSearchOnCL = true;

		printf("\n\nAuto-detection in progress please wait ...");
		int foundCamsCnt=m_camera->autodetect_cameras(bSearchOnCL, bSearchOnRS232, false);

		if(foundCamsCnt >0)
		{
			printf("\n\nFound %d connected Chromasens cameras:",foundCamsCnt);
			CS_CAMERA_INFORMATION_STRUCT cameraInfo;
			for (int i=0; i< foundCamsCnt; i++)
			{
				m_camera->get_camera_information(i, &cameraInfo);

				printf("\n\nCamera %d:"
					   "\n----------",i);

				printf("\nInterface: %s",cameraInfo.fullInterfaceDescription);
				if(cameraInfo.serialPortNo != -1) {
					printf("\nConnected via RS232 port number: %d", cameraInfo.serialPortNo);
				}
				
				if(cameraInfo.camLinkPortNo != -1){
					printf("\nConnected via CameraLink port number: %d",cameraInfo.camLinkPortNo);
				}
				printf("\nCamera serial number: %s", cameraInfo.cameraSerialNumber);
				
				if (cameraInfo.productType[0] != '\0')
				{
					printf("\nProduct ID \\ CP-Number is: %s",cameraInfo.productType);
				}

				printf("\n\nFirmware version: %d-%d-%d", cameraInfo.firmwareVersion[0], cameraInfo.firmwareVersion[1], cameraInfo.firmwareVersion[2]);
				printf("\nFPGA version: %d", cameraInfo.fpgaVersion);
				printf("\nFirmware description: %s", cameraInfo.firmwareDescription);
				printf("\nFPGA description: %s", cameraInfo.fpgaDescription);
			}
		}
		else
		{
			if (foundCamsCnt == 0){
				printf("\n\nNo Chromasens camera connected");
			} else {
				printf("\n\nError detecting cameras");
			}
		}
	}
	else
	{
		printf("\n\nError detecting cameras");
	}

}

//////////////////////////////////////////////////////////////////////////
/// Returns the information about the serial number, firmware and fpga-version
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::get_camera_information (void)
{
	if(m_isConnected)
	{
        CS_CAMERA_INFORMATION_STRUCT cameraInfo;
        if(m_camera->get_camera_information (&cameraInfo) == CS_OK)
		{
			printf("\n\nFirmware version: %d-%d-%d", cameraInfo.firmwareVersion[0], cameraInfo.firmwareVersion[1], cameraInfo.firmwareVersion[2]);
			printf("\nFPGA version: %d", cameraInfo.fpgaVersion);
			printf("\nFirmware description: %s", cameraInfo.firmwareDescription);
			printf("\nFPGA description: %s", cameraInfo.fpgaDescription);
			printf("\nCamera serial number: %s", cameraInfo.cameraSerialNumber);
			printf("\nPacket version: %d", cameraInfo.packetVersion);
			printf("\nPacket description: %s", cameraInfo.packetDescription);
			printf("\nPacket consistent: %s", (cameraInfo.packetConsistent ? "Yes" : "No"));
        }
		else
		{
			printf("\n\nError getting operation values from camera");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// This will trigger the camera to create a reference by the incoming image data
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::create_reference_internally(void)
{
	if(m_isConnected)
	{
		UINT referenceNo=0;
		CS_REFERENCE_MODE referenceType = BLACK_LEVEL_CORRECTION;
		UINT timeout = 60; // 60 seconds timeout
		
		printf("\n\nInternal reference generation");
		printf("\nMake sure that the camera is set into a valid working point and the correct target/light conditions are present.");
		printf("\nEnter reference number to store to (0 or 1): ");
		if(scanf_s("%d", &referenceNo) <= 0)
			referenceNo = 0;
		printf("Enter reference type to create (black level ref.: %d, or shading ref.: %d) ", BLACK_LEVEL_CORRECTION, SHADING_CORRECTION);
		if(scanf_s("%d", &referenceType) <= 0)
			referenceType = BLACK_LEVEL_CORRECTION;

		if(m_camera->create_reference_internally(referenceType, referenceNo, timeout) == CS_OK)
		{
			// Reference successfully created
			printf("Reference successfully created!\n");
		}
		else
		{
			printf("\nError getting operation values from camera");
		}
    }
    else
        printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Get the logging parameter of the CSAPI
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getLoggingParameter (void)
{
    char fileName[MAX_PATH];
    CS_LOGGING_PARAM_STRUCT LogParam;
    LogParam.pLogFileName = (char *) &fileName[0];

    if(m_camera->get_logging_parameter (&LogParam) == CS_OK)
    {
        printf("\n\nLogFileName: %s, Output to DbgViewer: %d", LogParam.pLogFileName, LogParam.OutputToDbgViewer);
        printf("\nLoggingMask: 0x%x, InterfaceLength: %d, TimeStamp: %d", LogParam.LoggingMask, LogParam.InterfaceDataLength, LogParam.TimeStamp);
    }
    else
    {
        printf("\n\nError getting logging parameter from camera");
    }
}

//////////////////////////////////////////////////////////////////////////
/// Set the logging parameter of the CSAPI
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setLoggingParameter( void )
{
    INT32 tmp=0; // Buffer variable because scanf is using 32 Bit values!
    float fTmp=0;

    CS_LOGGING_PARAM_STRUCT LogParams;
    bool bStoreToReg = false;
    char fileName[MAX_PATH];
    LogParams.pLogFileName = (char *) &fileName[0];

    printf("\n\nEnter path and name for logging data (0=empty) : ");
    if (scanf_s("%s", fileName, MAX_PATH) <= 0)
    {
        printf("Error entering file !")	;
        fileName[0] = 0;
    }
    else
    {
        if ( 0 == strcmp (fileName, "0") ) 
        {
            printf("empty fileName!\n")	;
            fileName[0] = 0;
        }
    }

    printf("Output data to DbgViewer(0=no or 1=yes): ");
    if(scanf_s("%d", &tmp) <= 0)
        tmp = 0;
    LogParams.OutputToDbgViewer = tmp;

    printf("Set logging mask (hex format): ");
    if(scanf_s("%x", &tmp) <= 0)
        tmp = 0;
    LogParams.LoggingMask = tmp;

    printf("Set Interface data length (0=off, 1=header, >1=complete): ");
    if(scanf_s("%d", &tmp) <= 0)
        tmp = 0;
    LogParams.InterfaceDataLength = tmp;

    printf("Insert Time Stamp (0=no or 1=yes): ");
    if(scanf_s("%d", &tmp) <= 0)
        tmp = 0;
    LogParams.TimeStamp = tmp;

    printf("Store to Registry(0=no or 1=yes): ");
    if(scanf_s("%d", &tmp) <= 0)
        tmp = 0;
    bStoreToReg = (tmp != 0);

    INT16 nError = m_camera->set_logging_parameter (LogParams, bStoreToReg);
    if( nError != CS_OK)
    {
        printf ("Error setting the logging parameters in the camera %d\n", nError);
    }
}

//////////////////////////////////////////////////////////////////////////
/// Get the internal camera trace messages and display them. Single messages 
/// are divided by a new line character
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::get_camera_trace(void)
{
	if(m_isConnected)
	{
		char* pTraceMsg=NULL;
		INT16 traceLength=0;

		if(m_camera->get_trace_from_camera(&pTraceMsg, traceLength) == CS_OK)
		{
			if((pTraceMsg != NULL) && traceLength > 0)
			{
				int dataOffset = 0;
				printf("\nTrace from camera:\n");
				while(dataOffset < traceLength-1)
				{
					printf("%s", pTraceMsg + dataOffset);
					int nStringLength = (int)(strlen(pTraceMsg +dataOffset));
					dataOffset += nStringLength + 1;
					if(nStringLength == 0)
						break;
				}
			}
		}
		else
		{
			printf("\n\nError getting trace from camera: %s");
		}

	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Get the currently active trace settings
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::get_trace_mode(void)
{
	if(m_isConnected)
	{
		UINT16 traceMode=0;
		if(m_camera->get_trace_mode(traceMode, true) == CS_OK)
		{
			printf("\nTrace modes:");
			printf("\nGeneral debug info \t\t%d", (traceMode & TRACE_GENERAL_DEBUG_INFO) != 0);
			printf("\nTransport layer \t\t%d", (traceMode & TRACE_TRANSPORT_LAYER)!= 0);
			printf("\nDetailed transport layer info:\t%d", (traceMode & TRACE_TRANSPORT_LAYER_DETAILS)!= 0);
			printf("\nWhite control \t\t\t%d", (traceMode & TRACE_WHITE_CONTROL)!= 0);
			printf("\nEnvironmental values \t\t%d", (traceMode & TRACE_ENVIRONMENT_VALUES)!= 0);
			printf("\nImage counter \t\t\t%d", (traceMode & TRACE_IMAGE_COUNTER) != 0);
		}
		else
		{
			printf("\n\nWas not able to retrieve the current trace mode!\n");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Set which kind of events should be logged into the camera trace
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::set_trace_mode(void)
{
	if(m_isConnected)
	{
		UINT16 traceMode = 0;
		int tmp;

		printf("\nSet the trace modes:");
		printf("\nGeneral debug info (0: no logging, 1: log into trace) ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		if(tmp > 0)
			traceMode = (traceMode | TRACE_GENERAL_DEBUG_INFO);
		printf("Transport layer (0: no logging, 1: log into trace) ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		if(tmp > 0)
			traceMode = (traceMode | TRACE_TRANSPORT_LAYER);
		printf("Detailed transport layer info (0: no logging, 1: log into trace)");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		if(tmp > 0)
			traceMode = (traceMode | TRACE_TRANSPORT_LAYER_DETAILS);
		printf("White control (0: no logging, 1: log into trace):");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		if(tmp > 0)
			traceMode = (traceMode | TRACE_WHITE_CONTROL);
		printf("nEnvironmental values (0: no logging, 1: log into trace):");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		if(tmp > 0)
			traceMode = (traceMode | TRACE_ENVIRONMENT_VALUES);
		printf("Image counter (0: no logging, 1: log into trace):");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		if(tmp > 0)
			traceMode = (traceMode | TRACE_IMAGE_COUNTER);
		
		if(m_camera->set_trace_mode(traceMode, true) != CS_OK)
		{
			printf("\nError setting the trace mode in the camera!!!\n");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// List all available Interfaces in the system
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::list_available_interfaces(void)
{
	// No check for connection is necessary. These functions can already be used before connecting to a camera
	INT16 interfaceCount = m_camera->get_number_of_available_interfaces();
	if( interfaceCount > 0)
	{
		INT16 clPortCount = m_camera->get_no_of_cameraLink_ports();
		INT16 rs232PortCount = m_camera->get_no_of_rs232_ports();
		printf("\nFound following interfaces (CL: %d RS232:%d", clPortCount, rs232PortCount);
		for(INT16 i = 0; i < interfaceCount; i++)
		{
			char* pInterfaceDescription=NULL;
			if(m_camera->get_interface_description(i, &pInterfaceDescription) == CS_OK)
				printf("\nInterface No:%d \t%s", i, pInterfaceDescription);
			else
				break;
		}
		printf("\n");
	}
	else
	{
		printf("\n\nNo interfaces available\n");
	}
}

//////////////////////////////////////////////////////////////////////////
/// Gets the parameters for the LED flash parameters
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getLedFlashSettings( void )
{
	if(m_isConnected)
	{
		CS_LED_FLASH_CONTROL_STRUCT ledFlashParams;
		if(m_camera->get_led_flash_parameters(&ledFlashParams, true) == CS_OK)
		{
			printf("\nFlash mode enabled: %d\n", ledFlashParams.enableFlashControl);
			printf("Number of flash patterns: %d\n", ledFlashParams.numberOfLinePatterns);
			printf("LED flash sequence time in us: %4.2f\n", ledFlashParams.flashSequenceTime);
			
			printf("\nPattern 1: \tPattern 2\tPattern 3\tPattern 4\n");
			for(int iOutput = 0; iOutput < CS_LED_FLASH_CONTROL_STRUCT::MAX_OUTPUTS; iOutput++)
			{
				for(int i = 0; i < CS_LED_FLASH_CONTROL_STRUCT::MAX_LED_FLASH_PATTERNS; i++)
				{
					printf("Output %d: %4.2f\t", iOutput + 1, ledFlashParams.flashDefinitions[i][iOutput]);
				}
				printf("\n");
			}
			if(determineCameraType() != ALLPIXA_WAVE)
			{
				printf("LED flash synchronisation: %d\n", ledFlashParams.ledDriverSync);
			}
		}
		else
		{
			printf("\n\nError getting led flash parameter from camera");
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

void CChromasensApiCalls::setLedFlashSettings( void )
{

	if(m_isConnected)
	{
		CS_LED_FLASH_CONTROL_STRUCT ledFlashParams;

		int nTmp=0;
		float dTmp = 0.0;
		printf("\nDisable(0) or enable(1) LED flash: ");
		if(scanf_s("%d", &nTmp) <= 0)
			nTmp = 0;
		ledFlashParams.enableFlashControl = nTmp;

		printf("\nNumber of flash-patterns(max. %d): ",CS_LED_FLASH_CONTROL_STRUCT::MAX_LED_FLASH_PATTERNS);
		if(scanf_s("%d", &nTmp) <= 0)
			nTmp = 0;
		if(nTmp < CS_LED_FLASH_CONTROL_STRUCT::MAX_LED_FLASH_PATTERNS)
			ledFlashParams.numberOfLinePatterns = nTmp;
		else
		{
			printf("Flash pattern count out of bounds!\nSetting parameter to:%d\n", CS_LED_FLASH_CONTROL_STRUCT::MAX_LED_FLASH_PATTERNS);
		}

		printf("LED flash sequence time in us: ");
		if(scanf_s("%e", &dTmp) <= 0)
			dTmp = 0;
		ledFlashParams.flashSequenceTime = dTmp;

		for(int i = 0; i < ledFlashParams.numberOfLinePatterns; i++)
		{
			printf("\nPattern no: %d\n", i);
			for(int iOutput = 0; iOutput < CS_LED_FLASH_CONTROL_STRUCT::MAX_OUTPUTS; iOutput++)
			{
				printf("Time for Output %i in us: ",iOutput);
				if(scanf_s("%e", &dTmp) <= 0)
					dTmp = 0;
				ledFlashParams.flashDefinitions[i][iOutput] = dTmp;
			}
			printf ("\n");
		}
		if(determineCameraType() != ALLPIXA_WAVE)
		{
			printf("Disable(0) or enable(1) LED synchronisation clock: ");
			if(scanf_s("%d", &nTmp) <= 0)
				nTmp = 0;
			ledFlashParams.ledDriverSync = nTmp;

			if(m_camera->set_led_flash_parameters(ledFlashParams, true) != CS_OK)
			{
				printf("\n\nError setting led flash parameter to camera");
			}
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Sends a given file to the camera flash
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::sendFile2CameraFlash( void )
{
	if(m_isConnected)
	{
		char fileName[MAX_PATH];
		printf("\nPlease enter the file to store to camera flash(including path):\n");
		if(scanf_s("%s", fileName, MAX_PATH) <= 0)
		{
			printf("Error entering file !")	;
		}

// 		struct stat st;
// 		if (stat(fileName, &st) == -1)
// 		{
// 			printf("Error getting file size: %s", std::strerror(errno));
// 		}
// 		if(st.st_size <= 0)
// 		{
// 			printf("File size not valid: %d", st.st_size);
// 			return;
// 		}
// 
// 		WORD* data2Write = new WORD[st.st_size];

		// Open File
		streampos size;
		char * memblock;

		ifstream file (fileName, ios::in|ios::binary|ios::ate);
		if (file.is_open())
		{
			size = file.tellg();
			size += size % 2; // Need to be able to fit into WORD boundaries!
			memblock = new char [(unsigned int)size];
			file.seekg (0, ios::beg);
			file.read (memblock, size);
			file.close();
		}
		else 
		{
			printf("Unable to open file");
			return;
		}


		int nErrorNo = 0;
		if(nErrorNo = m_camera->store_data_2_camera_memory((WORD*) memblock, (unsigned long)( size/2)) != CS_OK)
		{
			// Error sending hsi-file
			printf("sending the data to camera failed!\n");
			char* pErrTxt;

			m_camera->get_error_text(nErrorNo,&pErrTxt);
			if(pErrTxt)
			{
				int color = FOREGROUND_RED|FOREGROUND_INTENSITY;
				textattr(color);
				printf("ErrorNo: %d Text: %s",nErrorNo, pErrTxt);
				printf("\nPlease enter key to continue");
				_getch();
			}
		}
		if(memblock)
			delete[] memblock;
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Get data from the camera flash and save it to disk
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getFileFromCameraFlash( void )
{
	if(m_isConnected)
	{
		char fileName[MAX_PATH];
		printf("\nPlease enter the file name (including path) where the flash data should be stored to:\n");
		if(scanf_s("%s", fileName, MAX_PATH) <= 0)
		{
			printf("Error entering file !")	;
		}

		// Open File
		char * memblock;

		ofstream file (fileName, ios::out|ios::binary|ios::trunc);
		if (file.is_open())
		{
			unsigned long size = 65524;
			memblock = new char [size];

			// Get Data from camera
			int returnVal = 0;
			returnVal = m_camera->get_data_from_camera_memory((WORD*) memblock, size/2);
			if(returnVal < CS_OK)
			{
				// Error getting data from camera
				printf("getting the data from the camera failed!\n");
				char* pErrTxt;

				m_camera->get_error_text(returnVal,&pErrTxt);
				if(pErrTxt)
				{
					int color = FOREGROUND_RED|FOREGROUND_INTENSITY;
					textattr(color);
					printf("ErrorNo: %d Text: %s",returnVal, pErrTxt);
					printf("\nPlease enter key to continue");
					_getch();
				}
			}
			else
			{

				file.write(memblock, returnVal * 2);
			}

			if(memblock)
				delete[] memblock;
			file.close();
		}
		else 
		{
			printf("Unable to open file");
			return;
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Function retrieves the image data of one line from the camera
/// The user may choose in between text and image format
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getImageDataFromCamera()
{
	INT16 nReturn = CS_OK;
	if(m_isConnected)
	{
		int nDataFormat= RAW_PIXEL_VALUES;
		printf("Please choose the file format (%d=Text, %d=BMP): ", RAW_PIXEL_VALUES, BMP_IMAGE);
		scanf_s("%d", &nDataFormat);
		if(nDataFormat != RAW_PIXEL_VALUES)
			nDataFormat = BMP_IMAGE;

		char fileName[MAX_PATH];
		printf("\nEnter the path and name where the image data should be saved to\n(extension will be added automatically) \n");
		if(scanf_s("%s", fileName, MAX_PATH) <= 0)
		{
			printf("Error entering file !")	;
			return;
		}

		CS_IMAGE_PARAMETER_STRUCT imageParams;
		m_camera->get_image_parameters(&imageParams, false);
		WORD dataSize = imageParams.img_width * 3;
		if(nDataFormat != RAW_PIXEL_VALUES)
			dataSize += sizeof(t_BMPType);
		char* imageData = new char[dataSize];

		nReturn = m_camera->get_image_line_data_from_camera(imageData, dataSize, (CS_IMAGE_DATA_TYPE)nDataFormat);
		if(nReturn > 0)
		{
			// Save image data to file
		//	CFileException e;
			if(nDataFormat != RAW_PIXEL_VALUES)
			{
				strcat_s(fileName, ".bmp");
				try
				{
					ofstream f;

					f.open(fileName, ofstream::out | ofstream::binary );
					if(  !f.fail())
					{
						f.write( imageData, nReturn*2 );
						f.flush();
						f.close();
					}
					else
					{
						printf("Error open BMP image file for writing\n");
						return;
					}
				}
				catch(...)
				{
					printf("Error writing BMP image file: %s\n", fileName);
					return;
				}
			}
			else
			{
				strcat_s(fileName, ".txt");
				try
				{
					ofstream f;

					f.open(fileName, ofstream::out);
					if(  !f.fail())
					{
						f << "Pixel values of an image line \nBlue\tGreen\tRed" << endl;
						for(int i = 0; i < imageParams.img_width; i++)
						{
							f << +((unsigned char)imageData[i*3]) << "\t" << +((unsigned char)imageData[i*3+1]) << "\t" << +((unsigned char)imageData[i*3+2]) << endl;
						}
						f.flush();
						f.close();
					}
					else
					{
						printf("Error open TXT image file for writing\n");
						return;
					}
				}
				catch(...)
				{
					printf("Error writing txt image file: %s\n", fileName);
					return;
				}
			}

		}

		// Cleanup
		if(imageData)
		{
			delete[] imageData;
			imageData = NULL;
		}
	}
	else
	{
		printf("\n !!! Camera is not connected !!!\n");
	}
}

//////////////////////////////////////////////////////////////////////////
/// Get a specific Register value from the camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getRegisterValue(void)
{

	if(m_isConnected)
	{
		WORD offset = 0;
		WORD regValue=0xFFFF;
		int nTmp =0;

		printf("\n\nEnter register address to read(in HEX): ");
		if(scanf_s("%x", &nTmp) > 0)
			offset = nTmp;

		INT16 nError = m_camera->get_single_register(offset, regValue);
		if( nError != CS_OK)
		{
			printf ("Error getting a register value from the camera %d\n", nError);
		}
		else
		{
			printf("Read Register 0x%x: 0x%x", offset, regValue);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");
}

//////////////////////////////////////////////////////////////////////////
/// Set a specific Register value from the camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setRegisterValue(void)
{
	if(m_isConnected)
	{
		WORD offset = 0;
		WORD regValue=0xFFFF;
		int nTmp =0;

		printf("\n\nEnter register address to write(in HEX): ");
		if(scanf_s("%x", &nTmp) > 0)
			offset = nTmp;
		printf("\nEnter value to write(in HEX): ");
		if(scanf_s("%x", &nTmp) > 0)
			regValue = nTmp;

		INT16 nError = m_camera->set_single_register(offset, regValue);
		if( nError != CS_OK)
		{
			printf ("Error setting register value in the camera %d\n", nError);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

///////////////////////////////////////////////////////////////////////////
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// This section is only valid for allPIXA wave cameras!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
///////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
/// Get the linear gain values of the allPIXA wave camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getLinearGainValues(void)
{
	if(m_isConnected)
	{
		// get the available number of gain values
		CS_LINEAR_GAIN_STRUCT linearGain;
		char colorNames[MAX_SENSOR_LINES][10] = {"Red","Green", "Blue", "White"};

		if(m_camera->get_linear_gain_values(&linearGain, true) == CS_OK)
		{
			int maxLoops = max(MAX_SENSOR_LINES, linearGain.no_of_valid_entries);
			printf("\n\nThe values of the gain settings:\n");
			for(int i = 0; i < linearGain.no_of_valid_entries; i++)
			{
				printf("Element %d (%s): \t%5.3f\n", i, colorNames[i], linearGain.value[i]);
			}
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Set the gain values of the allPixa wave camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setLinearGainValues(void)
{
	if(m_isConnected)
	{
		// get the available number of gain values
		CS_LINEAR_GAIN_STRUCT linearGain;
		char colorNames[MAX_SENSOR_LINES][10] = {"Red","Green", "Blue", "White"};

		if(m_camera->get_linear_gain_values(&linearGain) == CS_OK)
		{
			printf("\n");
			int maxLoops = min(MAX_SENSOR_LINES, linearGain.no_of_valid_entries);
			for(int i = 0; i < maxLoops; i++)
			{
				float fTmp=0;
				printf("Please enter the Gain-Value for the %s channel (double): ", colorNames[i]);
				if(scanf_s("%e", &fTmp) <= 0)
					fTmp = 0.0;

				linearGain.value[i] = fTmp;
			}
			m_camera->set_linear_gain_values(linearGain);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Get the sensitivity values of the allPIXA wave camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::getSensorSensitivityValues( void )
{
	if(m_isConnected)
	{
		// get the available number of gain values
		CS_SENSOR_SENSITIVITY_STRUCT sensorSensitivity;
		char colorNames[MAX_SENSOR_LINES][10] = {"Red","Green", "Blue", "White"};

		if(m_camera->get_sensor_sensitivity_values(&sensorSensitivity, true) == CS_OK)
		{
			int maxLoops = max(MAX_SENSOR_LINES, sensorSensitivity.no_of_valid_entries);
			printf("\n\nThe values of the sensitivity settings:\n");
			for(int i = 0; i < sensorSensitivity.no_of_valid_entries; i++)
			{
				printf("CDS gain %d (%s): \t%d (0 = x1, 1 = x2)\n", i, colorNames[i], sensorSensitivity.cds_gain[i]);
			}
			for(int i = 0; i < sensorSensitivity.no_of_valid_entries; i++)
			{
				printf("Sensitivity %d (%s): \t%d (%d = high dynamic, %d = high sensitivity)\n", i, colorNames[i], sensorSensitivity.sensitivity[i], HIGH_DYNAMIC, HIGH_SENSITIVITY);
			}
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

//////////////////////////////////////////////////////////////////////////
/// Set the sensitivity values of the allPIXA wave camera
//////////////////////////////////////////////////////////////////////////
void CChromasensApiCalls::setSensorSensitivityValues( void )
{
	if(m_isConnected)
	{
		// get the available number of gain values
		CS_SENSOR_SENSITIVITY_STRUCT sensorSensitivity;
		char colorNames[MAX_SENSOR_LINES][10] = {"Red","Green", "Blue", "White"};

		if(m_camera->get_sensor_sensitivity_values(&sensorSensitivity) == CS_OK)
		{
			printf("\n");
			int maxLoops = min(MAX_SENSOR_LINES, sensorSensitivity.no_of_valid_entries);
			for(int i = 0; i < maxLoops; i++)
			{
				int tmp=0;
				printf("Please enter the CDS Gain-factor for the %s channel (0 = x1, 1 = x2): ", colorNames[i]);
				if(scanf_s("%d", &tmp) <= 0)
					tmp = 0;

				sensorSensitivity.cds_gain[i] = tmp;
			}
			for(int i = 0; i < maxLoops; i++)
			{
				int tmp=0;
				printf("Please enter the Sensitivity for the %s channel (%d = high dynamic, %d = high sensitivity): ", colorNames[i], HIGH_DYNAMIC, HIGH_SENSITIVITY);
				if(scanf_s("%d", &tmp) <= 0)
					tmp = 0;

				sensorSensitivity.sensitivity[i] = tmp;
			}
			m_camera->set_sensor_sensitivity_values(sensorSensitivity);
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

void CChromasensApiCalls::getROIParameter( void )
{
	if(m_isConnected)
	{
		// get the ROI parameters
		CS_ROI_PARAMETER_STRUCT roiParameters;

		if(m_camera->get_roi_parameters(&roiParameters, true) == CS_OK)
		{
			printf("\n\nThe roi values:\n");
			printf("Image start delay \t%d \n", roiParameters.first_scan_line_delay);
			printf("Image height \t\t%d \n", roiParameters.img_height);
			for(int i = 0; i < MAX_ROIS; i++)
			{
				printf("ROI %d active: %d \tstart: %d \twidth: %d\t\n", i, roiParameters.roi_active[i], roiParameters.roi_start[i], roiParameters.roi_width[i]);
			}
		}
	}
	else
		printf("\n !!! Camera is not connected !!!\n");


}

void CChromasensApiCalls::setROIParameter( void )
{
	if(m_isConnected)
	{
		// Set the available number of gain values
		CS_ROI_PARAMETER_STRUCT roiParameter;
		INT32 tmp=0;

		printf("Scan line delay: ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		roiParameter.first_scan_line_delay = tmp;
		printf("Image height: ");
		if(scanf_s("%d", &tmp) <= 0)
			tmp = 0;
		roiParameter.img_height = tmp;

		for(int i = 0; i < MAX_ROIS; i++)
		{
			printf("ROI %d", i);
			printf("ROI active (0/1): ");
			if(scanf_s("%d", &tmp) <= 0)
				tmp = 0;
			roiParameter.roi_active[i] = (tmp != 0);
			printf("ROI start: ");
			if(scanf_s("%d", &tmp) <= 0)
				tmp = 0;
			roiParameter.roi_start[i] = tmp;
			printf("ROI length: ");
			if(scanf_s("%d", &tmp) <= 0)
				tmp = 0;
			roiParameter.roi_width[i] = tmp;
		}
		m_camera->set_roi_parameters(roiParameter);
	}
	else
		printf("\n !!! Camera is not connected !!!\n");

}

///////////////////////////////////////////////////////////////////////////
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// end of allPIXA wave camera section!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
///////////////////////////////////////////////////////////////////////////
