#pragma once
#include "../CS_API/ChromasensCameraIf.h"
using namespace CSAPI;
class CChromasensApiCalls
{
public:
	CChromasensApiCalls(void);
	~CChromasensApiCalls(void);
	void getGainValues(void);
	void setGainValues(void);
	void getLinearGainValues(void);
	void setLinearGainValues(void);
	void setCameraWhiteBalancingSetup(void);
	void getCameraWhiteBalancingSetup(void);
	void getCDSGainValues(void);
	void setCDSGainValues(void);
	void getSensorSensitivityValues(void);
	void setSensorSensitivityValues(void);
    void getCurrentWhiteReferenceValues(void);
	void getInitialGainValues(void);
	void setInitialGainValues(void);
	void getTestPatternSettings(void);
	void setTestPatternSettings(void);
	void getIntegrationTimeSettings(void);
	void setIntegrationTimeSettings(void);
	void getBrightnessAndContrast(void);
	void setBrightnessAndContrast(void);
	void calculateReference(void);
	void getImageParameter( void );
	void setImageParameter( void );
	void getROIParameter( void );
	void setROIParameter( void );
	void doTabBalancing(void);
	void checkWhiteBalance(void);
	void burnSettingToCamera(void);
	void selectSetting(void);
	INT16 saveCurrentSetting();
	INT16 getSettingDescription();
	INT16 setSettingDescription();
	void showAvailableSettings(void);
	void getVarTag(void);
	void sendVarTag(void);
	void getLongTag(void);
	void sendLongTag(void);
	void getShortTagCyclic(void);
	void getShortTag(void);
	void sendShortTag(void);
	void getBinTag(void);
	void sendBinTag(void);
	void sendHSIFile(void);
	void sendFileList2Camera( void );
    void getCamLinkProps( void );
    void setCamLinkProps( void );
    int connectCamera (void);
    INT16 InitAPI();
	bool isConnected(void);
	INT16 determineCameraType();
	INT16 getCurrentSettingNumber();
	INT16 resetCamera();
	INT16 closeInterface(void);
	void autoDetectCameras(void);
	void getReferenceSettings( void );
	void setReferenceSettings( void );
	void prepareCam4Reference( void );
	void getImageProcessingParameter( void );
	void setImageProcessingParameter( void );
	void getPhysicalSetupParameter( void );
	void setPhysicalSetupParameter( void );
	void getVideoOutputParameter( void );
	void setVideoOutputParameter( void );
	void getTriggerSettings(void);
	void setTriggerSettings(void);
	void getEncoderParameters( void );
    void setEncoderParameters( void );
    void getIOConfigurationParameter (void);
    void setIOConfigurationParameter (void);
    void get_camera_operating_values (void);
    void get_camera_information (void);
	void getCameraState(void);
	void create_reference_internally(void);
	void get_camera_trace(void);
	void get_trace_mode(void);
    void getLoggingParameter (void);
	void setLoggingParameter ( void );
	void set_trace_mode(void);
	void list_available_interfaces(void);
	void getLedFlashSettings( void );
	void setLedFlashSettings( void );
	void sendFile2CameraFlash(void);
	void getFileFromCameraFlash(void);
	void getImageDataFromCamera(void );
	void getInternalLightBarrierSettings( void );
	void setInternalLightBarrierSettings( void );
	void getRegisterValue(void);
	void setRegisterValue(void);
protected:
	// Object of the chromasens camera interface
	CChromasensCameraIf* m_camera;
	bool m_isConnected ;
	HINSTANCE m_hCamIfLib;
	WORD m_tagID ;		// Last used tagID
};

