//-------------------------------------------------------------------------
// PROJEKT: KA8
// DATEI:   ka4errmsg.h
// BESCHREIBUNG: Fehlercodes
// 10.12.2013: error codes adapted to allPixa dependecies
//-------------------------------------------------------------------------

#define OK                               0

// error classes   --------------------------------------------------------
// is coded in the first byte of the error message

#define ECL_SERVICE_WARNING              1
#define ECL_OP_WARNING                   2
#define ECL_PAR_ERR                      3
#define ECL_INIT_ERR                     4
#define ECL_HWSW_ERR                     5


// Transportlayer -------------------------------------------------------
// errors are not reported via HSI
// reported via NAK-Frame

#define TRL_INVALID_SOH                   0xA
#define TRL_NO_DATAFRAME                  0xB
#define TRL_CHECKSUMERR                   0xC
#define TRL_RX_TIMEOUT                    0xD
#define TRL_TX_TIMEOUT                    0xE
#define TRL_UNEXPECTED_FRAME              0x0F


// HW errors ----------------------------------------------------------
// errors are not reported via HSI

#define STACK_OVERFLOW                    0x0C
#define STACK_UNDERFLOW                   0x0D
#define UNDEFINED_OPCODE_TRAP             0x11
#define PROTECTION_FAULT_TRAP             0x12
#define ILLEGAL_WOP_ACC_TRAP              0x13
#define ILLEGAL_INSTR_ACC_TRAP            0x14
#define ILLEGAL_EXT_BUS_ACC_TRAP          0x15


//  error codes are coded in the third byte of the error Message

#define CHECK_DATA_ERROR                  0x2e     //  copy SRAM -> Flash
#define LASTDATAFRAME_BEFORE_ALL_DATA_RECEIVED  0x2f //  Error in long HSI command structure

// POT errors ---------------------------------------------------------
// note: the POT errors can also be reported during normal operation of the scanner

#define POW_LOW24V                    0x30         //  input voltage POW below limit
#define POW_HEAT                      0x31         //  temperature of POW board exceeds limit
#define LEDA_HEAT                     0x32         //  LED A: temperature exceeds limit
#define LEDB_HEAT                     0x33         //  LED B: temperature exceeds limit
#define LEDA_REFCHAN                  0x34         //  LED A: no current at reference channels (i.e. one LED channel defective or LED module coding error or LED module not present)
#define LEDB_REFCHAN                  0x35         //  LED B: no current at reference channels (i.e. one LED channel defective or LED module coding error or LED module not present)
#define CURRENT_OFFA                  0x36         //  LED A: no. of channels with no current invalid (i.e. one LED channel defective or LED module coding error)
#define CURRENT_OFFB                  0x37         //  LED B: no. of channels with no current invalid (i.e. one LED channel defective or LED module coding error)
#define BALANCEA                      0x38         //  LED A: current difference within module exceeds limit (i.e. LED chip defective)
#define BALANCEB                      0x39         //  LED B: current difference within module exceeds limit (i.e. LED chip defective)
#define BALANCEAB                     0x3a         //  current difference between LED A and B exceeds limit
#define TEMPERR_A                     0x3b         //  LED A: error at reading temperature sensor (i.e. LED module or sensor not present)
#define TEMPERR_B                     0x3c         //  LED B: error at reading temperature sensor (i.e. LED module or sensor not present)
#define TEMPERR_BOARD                 0x3d         //  temperature of board exceeds limit
#define TEMPERR_SENS                  0x3e         //  temperature of sens exceeds limit
#define FIRMWARE_CHECK_ERROR          0x3f         //  ChecksumError in Firmware detected
#define INTERNAL_TEMP_ERR             0x40         //  internal temperature exceeds limit -> check cooling environment, restart of camera neccessary!
// errors -------------------------------------------------------------

#define MIN_GAIN_WARNING                  0x41     //  minimum gain exceeded
#define MAX_WHITEVALDIFF_WARNING          0x42     //  maximum difference between white references values
#define VIDEO_VALUE_DROPDOWN_ERR		  0x43     //  Drop down of video value, maybe caused by break of CCD cable (CLSC2050)
#define TIMEOUT_WHITE_REFS		          0x44     //  Timeout for white reference values for gain control
#define DATA_LENGTH_ERR                   0x49     //  invalid length
#define DP_RDCHECK_ERR                    0x4A     //  verify error programming Flash EPROM
#define NO_VALID_SENS_DATA                0x4B     //  no valid CCD Data
#define UNKNOWN_SENSID                    0x4C     //  wrong sensor id

#define NO_VALID_BLACKREF                 0x4D     //  invalid black level reference 
#define NO_VALID_WHITEREF                 0x4E     //  invalid white/shading reference
#define AVERAGE_NOT_ALLOWED               0x4f     //  Cmd IK: SHC set active and averaging selected (Cmd Ik not used)

#define SERIALNO_CHANGE_FAILED            0x50     //  error changing internal serial number
#define WRONG_FPGA_DATA_FOR_BOARD         0x51     //  invalid DL file
#define OUTMODEPAERR                      0x52     //  inalid value for "video output mode"
#define NO_VALID_AFE_ADR                  0x53     //  access to invalid AFE address, internal sw err
#define INVALID_CMD_LEN                   0x54     //  invalid command length at AP or AC order
#define AP_TIMEOUT                        0x55     //  Adjustment of desired values for gain control (AP) canceled with timeout
#define AC_ADJUST_FAILURE                 0x56     //  Adjustment of correction values (AC) finished with error or timeout
#define AP_RETURN_ERR                     0x57     //  Order AP returned with error
#define AP_ILLUM_TOO_DARK                 0x58     //  Adjustment of desired values (AP): Illumination too dark
#define AP_ILLUM_TOO_BRIGHT               0x59     //  Adjustment of desired values (AP): Illumination too bright
#define AP_WREF_TOO_DARK                  0x5A     //  Adjustment of desired values (AP): WREF mark too dark
#define AP_GAIN_CORR_NARROW               0x5B     //  Adjustment of desired values (AP): Gain corridor too narrow, no fitting light intensity possible
#define AP_BURN_SET_ERR                   0x5C     //  Adjustment of desired values (AP): Error on storing settings
#define AP_WREF_TOO_BRIGHT                0x5D     //  Adjustment of desired values (AP): WREF mark too bright
#define AP_BREF_TOO_HIGH                  0x5E     //  Adjustment of desired values (AP): Level of black reference too high for given max desired values

#define MAXLENGTH_FAILURE                 0x60     //  Value MaxLength too high
#define BREFRANGE_FAILURE                 0x61     //  Blackrefdata out of range
#define PIPELINEOVERFLOW                  0x62     //  DocsInPipeline overflow
#define PAR_ILLEGAL_VALUE                 0x68     //  illegal parameter value, wrong configuration
#define PAR_ILLEGAL_LENGTH                0x69     //  illegal parameter length
#define PAR_ERR_ENCODER                   0x6A     //  invalid parameter for encoder setup

#define TA_INDEPENDENT_TABS               0x6D     //  Tab adjustment not useful at independent tabs
#define TA_TIMEOUT                        0x6E     //  Time Out Tab Border Adjustment
#define TA_ERROR                          0x6F     //  Error Tab Border Adjustment

#define VOLTERR_ANA1                      0x70     //  voltage Analog1 exceeds limit
#define VOLTERR_ANA2                      0x71     //  voltage Analog2 exceeds limit
#define VOLTERR_CORE                      0x72     //  voltage VCore exceeds limit
#define VOLTERR_SUP1                      0x73     //  voltage Supply1 exceeds limit
#define VOLTERR_SUP2                      0x74     //  voltage Supply2 exceeds limit
#define VOLTERR_SUP3                      0x75     //  voltage Supply3 exceeds limit
#define VOLTERR_CCD                       0x76     //  voltage CCD exceeds limit
#define FAN_ERROR                         0x77     //  Fan is not running
#define FAN2_ERROR						  0x78	   //  Fan 2 is not running
#define VIN_LED_ERROR					  0x79	   //  Vin LED controller eceeds limit

#define RS232_NAK_REC                     0x80     //  (not used)
#define RS232_ACK_TIMEOUT                 0x81     //  timeout waiting for ETX (not used)
#define RS232_TIMEOUT_GRANT_TX            0x82     //  Timeout waiting for free channel for sending sencond or further frame (ACK missing)
#define RS232_TIMEOUT_TX                  0x83     //  Timeout waiting for free Tx Channel for dending first frame (ACK missing)
#define MASTERSLAVE_CHECKSUM_ERROR        0x84     //  Synchronisation Error on Master/Slave-Interface detected
#define CL_LINEGAP_UNDERFLOW              0x85     //  line gab at Camera Link transfer too short

#define LC_INTERFACE_ERR                  0x90     //  Error at interface to Led-Controller
#define FPGA_CCD_MISMATCH                 0x91     //  FPGA data not fitting for sensor

#define LED_FAILURE                       0xA0     //  Error-Register from FPGA on camera electronic [*]
                                                   //  /* 0x100 oder 0x200 (LED_A_FAILURE or LED_B_FAILURE)*/
                                                   //  /* only with KAx;   x < 6    */
#define LED_REG_FAILURE                   0xA1     //  Desired Gain levels could not reached
#define LED_REG_WARNING                   0xA2     //  no longer used
#define LED_MAXLEVEL_WARNING              0xA3     //  Max level of LED duty cycle is exceeded
#define LED_DISABLED                      0xA4     //  Error-Register from FPGA on camera electronic [*]
					                               //  /* project specific: TS-Scanner-Project: 0x200 */

#define AFE_DPSLOCK_ERROR                  0xA5    //  error at sync to CCD board
#define DS_DAC_ADJ_ERROR                   0xA6    //  error at DS DAC adjustment, min /max error
#define DS_DAC_ADJ_TO                      0xA7    //  DS-DAC adjust timeout


#define INT_SHC_NOT_SUPPORTED             0xAA     //  internal SHC generation not supported
#define AFE_SYNC_ERROR                    0xAB     //  No valid data from AFE
#define BYTEACESS_ERROR                   0xAC     //  Register acces with byte acces (Adress with LSB != 0)

#define INCREMENTS_TOO_FAST               0xB0     //  Error-Register from FPGA on camera electronic [*]
                                                   //  /* 0x1 transport speed to high */
#define HSYSTOP_AFTER_END_INTTIME         0xB1     //  Error-Register from FPGA on camera electronic [*]
                                                   //  /* 0x2 HSYNC length exceeds integration time  */
#define PAPERLENGTHOVERRUN                0xB2     //  Error-Register from FPGA on camera electronic [*]
						                                 //  /* 0x4: too much scanlines in one document */
#define TRIGOVERRUN                       0xB3     //  Error-Register from FPGA on camera electronic [*]
						                                 //  /* 0x8: multiple image trigger  */
#define HARD_STOPP_SMC                    0xB4     //  Error-Register from FPGA on camera electronic [*]
						                                 //  /* 0x10: only valid if KA controls motor  */
					                                    //  /* hard stopp of SMC, start ans stop signal active simultaniously */
#define FIR_FILTER_ERROR                  0xB5     //  Error in filter file
#define REFDATA_DOES_NOT_MATCH            0xB6     //  start of BREF-data and WREF-data does not match (not used)
#define TIMEOUT_WAITING_FOR_RESAMPLING    0xB7     //  ImageProc. Hw Error
#define CREATE_FIR_FILTER_ERROR           0xB8     //  Error creating filter tables (SW error)
#define LOAD_FIR_FILTER_ERROR             0xB9     //  (not used)
#define LOAD_COLOR_PROFILE_ERROR          0xBA     //  error in Colour Management file (CMD_DD)
#define LOAD_TCA_DATA_ERROR               0xBB     //  error in TCA file (CMD_DC)
#define SCALE_FACTOR_ERROR                0xBC     //  illegal interpolation/reduction value
#define TAG_FORMAT_ERROR                  0xBD     //  HSI CMD structure error
#define MR_CMD_ERROR                      0xBE     //  MR Comand error (format, time out)
#define GENERAL_CCM_ERROR                 0xBF     //  Failure in CCM file selection

#define XILINX_NOT_READY                  0xC0     //  FPGA could not be erased before loading
#define XILINX_TIMEOUT1                   0xC1     //  (not used)
#define XILINX_TIMEOUT2                   0xC2     //  FPGA,Timeout waiting for done after loading
#define XILINX_DATA_ERROR                 0xC3     //  FPGA, No Init=0 before loading
#define XILINX_NO_DATA                    0xC4     //  FPGA, DL file not available/correct
#define XILINX_RW_ERROR                   0xC5     //  FPGA RW test error
#define FEPROM_ERASESEC_TIMEOUT           0xC6     //  Timeout erasing a Flash EPROM sector
#define FEPROM_WRITE_TIMEOUT              0xC7     //  Timeout writing to Flash EPROM
#define OUTP_IMG_SIZE_ERROR               0xC9     //  invalid output size for interpolation
#define XILINX_INVALID_DATA               0xCA     //  invalid XILINX data in flash memory
#define EXTERNALIOCONFIG				  0xCB     //  Undefined IO Assignment
#define AP_TARGET_VIDEO_LEVEL_NOT_VALID   0xCC     //  Destination Value for AP is not valid
#define LED_REG_TIMEOUT                   0xCD     //  Timeout during led control process
#define IOCONFIG_DEF_MISSING			  0xCE     //  Pin definition missing in IO Assignment Configuration
#define CPLD_VERSION_ERROR                0xCF     //  version of CPLD too low

#define NOT_ALLOWED_IN_STATE              0xD0     //  illegal state transition

#define WREF_CROSSES_TAPBORDER            0xD1     //  Wref position crosses tab border
#define WREF_OUTSIDE_VALIDAREA            0xD2     //  Wref below 0 or above valid number of pixel. If tabs are controlled independently and position is above tab border.
#define INVALID_RBG_LINEDISTANCE          0xD3     //  Value for RGB line distance out of range
#define CL_LINEPERIOD_FAILURE             0xD4     //  Int time / Line periode to fast for CamLink settings
#define WREF_VERTICAL_POSERR              0xD5     //  error in vertical position of Wref area
#define MAX_INTTIME_FAILURE               0xD6     //  value for integration time exceeds maximum
#define PATTERN_TOO_LARGE         		  0xD7     //  LED flash mode: sum of all pattern exceed sequence time. If pattern time is too small depending on min. integration time and CameraLink speed camera will automatically increase pattern time
#define PINLEDFLASH_ALREADYUESED		  0xD8     //  Output pins used for LED flash mode are already used in IO Configuration
#define SEQTIME_TOO_SHORT         		  0xD9     //  LED flash mode: sequence time too short for given integration time and number of pattern
#define INTLB_ROI_CROSSES_TAPBORDER       0xDA     //  ROI for internal light barrier crosses tab border
#define NUMBER_PATTERN_RANGE_ERROR        0xDB     //  LED flash mode: number line pattern exceeds valid range

#define VALKEY_NOTALLOWED                 0xDD     //  programming of license key not allowd
#define INVALID_FUNCTIONKEY               0xDE     //  license key invalid
#define FUNCTION_NOTLICENSED              0xDF     //  selected function not licensed for this camera

#define UNKNOWN_COMMAND                   0xE1     //  unknown command
#define CHECKSUM_INVALID                  0xE2     //  wrong HSI check sum
//#define WRONG_FIR_LEN                   0xE3     //  wrong filter length, software error

#define WHITECONTROL_IS_DISABLED          0xE4     //  WR: condition for white control missing 
                                                   //      encoder mode active? -> no encoder clocks received
                                                   //      external trigger active? -> no trigger received
#define NO_FILTER                         0xE5     //  No filter file (Cmd DD) loaded but activated
#define SHC_TIMEOUT1                      0xE6     //  error at internal SHC generation (no used)
#define SHC_TIMEOUT2                      0xE7     //  error at internal SHC generation (no used)
#define SETTING_IS_EMPTY                  0xE8     //  selected setting is empty (not stored previously)
#define HSY_TIMEOUT                       0xEA     //  time on waiting for edge of hsync signal
#define NO_REGKL                          0xEB     //  White control characteristic not loaded
#define NO_SHCKENN                        0xEC     //  error at internal SHC generation (no used)
#define FBG_KENN_ERR                      0xED     //  downloaded data not valid for board
#define SEL_SETTING_ERR                   0xEF     //  error selecting setting

#define NO_CONFIG_FOUND                   0xF0     //  error selecting setting by resolution
#define HSYLENGTH_ERR                     0xF1     //  Mismatch Selected Scanline length to CCD Parameter
#define NO_BLACKREFKENN                   0xF2     //  error at internal offset generation (no used)
#define REGDATAKENN_FAIL                  0xF3     //  error on reading WREF data, wrong marker with data stream
#define KEYSTONE_FAILURE                  0xF4     //  Error in value for Keystone correction
#define LINEPERIOD_FAILURE                0xF5     //  Error in value of  line period
#define MAX_GAIN_WARNING                  0xF6     //  maximum gain exceeded
#define WHITE_BALANCE_FAILURE             0xF7     //  White balance can not be leveled [*]
                                                   //  /*   ( CMD_WR, or check white before start)   */
#define MIN_INTTIME_FAILURE               0xF8     //  integration time under set limit
#define FIRST_ACTIVE_PIXEL_FAILURE        0xF9     //  (no used)
#define LAST_ACTIVE_PIXEL_FAILURE         0xFA     //  PA cmd with illegal size and/or start of ROI
#define NO_ACT_CCD_DATA                   0xFB     //  invalid CCD/AFE File
#define NO_GAMMATABLES_LOADED             0xFC     //  invalid/no Gamma tables loaded
#define UNDEFINED_TOD_PAR                 0xFD     //  undefined 'type of data' in CMD_DD
#define NO_VALID_GAMMATABLEINDEX          0xFE     //  invalid Gamma value

// end of error definitions --------------------------------------------------
