﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

namespace csharp_CS_API_Test
{
    class API_Test
    {
        public enum MENUS:int 
        {
            START_COMMANDS_MENU = 0,
            RAW_COMMANDS_MENU,
            COMMAND_MENU1,
            COMMAND_MENU2,
            COMMAND_MENU3,
            COMMAND_MENU4,
            COMMAND_MENU5,
            COMMAND_DEBUG
        }

        public enum Color
        {
            GREEN,
            RED,
            ENABLED,
            DISABLED
        }
        [DllImport("msvcrt")]
        static extern int _getch();
        public static string [] menu_list = new string[13];
        public static int nCurrentSetting = -1;
        protected static int currentMenu = (int) MENUS.START_COMMANDS_MENU;

        //////////////////////////////////////////////////////////////////////////
        // Set the text color
        //////////////////////////////////////////////////////////////////////////
        public static void textattr(Color c)
        {
            switch (c)
            {
                case Color.GREEN:
                    Console.ForegroundColor = ConsoleColor.Green;
                    break;
                case Color.RED:
                    Console.ForegroundColor = ConsoleColor.Red;
                    break;
                case Color.DISABLED:
                    Console.ForegroundColor = ConsoleColor.DarkGray;
                    break;
                default:
                    Console.ForegroundColor = ConsoleColor.White;
                    break;
            }

        }

        //////////////////////////////////////////////////////////////////////////
        /// Display functions for the different menus
        //////////////////////////////////////////////////////////////////////////
        public static void displayFunctions(int menuNo)
        {
            textattr(Color.GREEN);
            Console.WriteLine("--------------------------------------------");
            Console.WriteLine("Chromasens Camera API demonstration program");
            Console.WriteLine("--------------------------------------------");
            Console.WriteLine("Connected: " + Convert.ToInt16(Functions.isConnected()) + "   Current Setting: " + nCurrentSetting + "\n");

            switch (menuNo)
            {
                case (int)MENUS.START_COMMANDS_MENU:
                    Array.Resize(ref menu_list, 10);
		            menu_list[0] = "(0) Open Connection"; //
                    menu_list[1] = "(1) Auto detect camera";
		            menu_list[2] = "(2) Show raw functions menu";
		            menu_list[3] = "(3) Show command menu 1";
		            menu_list[4] = "(4) Show command menu 2";
		            menu_list[5] = "(5) Show command menu 3";
		            menu_list[6] = "(6) Show command menu 4";
		            menu_list[7] = "(7) Show command menu 5";
                    menu_list[8] = "(8) Show command debug";
		            menu_list[9] = "(q) Quit program";
                    break;
                case (int)MENUS.RAW_COMMANDS_MENU:
                    Array.Resize(ref menu_list, 11);
		            menu_list[0] = ("(0) Get Bin tag");
		            menu_list[1] = ("(1) Send BIN tag");
		            menu_list[2] = ("(2) Get SHORT tag");
		            menu_list[3] = ("(3) Send SHORT tag");
	                menu_list[4] = ("(4) Get LONG tag");
		            menu_list[5] = ("(5) Send LONG tag");
		            menu_list[6] = ("(6) Get VAR tag");
		            menu_list[7] = ("(7) Send VAR tag");
		            menu_list[8] = ("(8) Send HSI-file");
		            menu_list[9] = ("(m) Main menu");
		            menu_list[10] = ("(q) Quit program");
                    break;

                case (int)MENUS.COMMAND_MENU1:
                    Array.Resize(ref menu_list, 14);
		            menu_list[0] = ("(0) Select Setting");
		            menu_list[1] = ("(1) Show available settings");
		            menu_list[2] = ("(2) Burn Settings to camera");
		            menu_list[3] = ("(3) Save current setting to disk");
		            menu_list[4] = ("(4) Get setting description");
		            menu_list[5] = ("(5) Set setting description");
		            menu_list[6] = ("(6) Reset camera"); //
		            menu_list[7] = ("(7) Get reference settings");
		            menu_list[8] = ("(8) Set reference settings");
		            menu_list[9] = ("(9) Prepare camera for reference");
		            menu_list[10] = ("(a) Calculate reference (shading/Offset)");
		            menu_list[11] = ("(b) Create reference internally (shading/Offset)");
		            menu_list[12] = ("(m) Main menu");
		            menu_list[13] = ("(q) Quit program");
                    break;

                case (int)MENUS.COMMAND_MENU2:
                    Array.Resize(ref menu_list, 13);
		            menu_list[0] = ("(0) get gain values"); //
		            menu_list[1] = ("(1) set gain values"); //
		            menu_list[2] = ("(2) get initial gain values"); //
		            menu_list[3] = ("(3) set initial gain values"); //
		            menu_list[4] = ("(4) get analog coarse gain"); //
		            menu_list[5] = ("(5) set analog coarse gain"); //
		            menu_list[6] = ("(6) get current white reference values");
		            menu_list[7] = ("(7) get white balancing setup");
		            menu_list[8] = ("(8) set white balancing setup");
		            menu_list[9] = ("(9) Check white balancing state");
		            menu_list[10] = ("(a) Do tab balancing");
		            menu_list[11] = ("(m) Main menu");
		            menu_list[12] = ("(q) Quit program");
                    break;

                case (int)MENUS.COMMAND_MENU3:
                    Array.Resize(ref menu_list, 12);
		            menu_list[0] = ("(0) get image parameters");
		            menu_list[1] = ("(1) set image parameters");
		            menu_list[2] = ("(2) get integration time settings");
		            menu_list[3] = ("(3) set integration time settings");
		            menu_list[4] = ("(4) get CamLink properties");
		            menu_list[5] = ("(5) set CamLink properties");
		            menu_list[6] = ("(6) get brightness and contrast settings"); //
		            menu_list[7] = ("(7) set brightness and contrast settings"); //
		            menu_list[8] = ("(8) get image processing parameters");
		            menu_list[9] = ("(9) set image processing parameters");
		            menu_list[10] = ("(m) Main menu");
		            menu_list[11] = ("(q) Quit program");
                    break;

                case (int)MENUS.COMMAND_MENU4:
                    Array.Resize(ref menu_list, 14);
		            menu_list[0] = ("(0) get physical setup parameters");
		            menu_list[1] = ("(1) set physical setup parameters");
		            menu_list[2] = ("(2) get video output parameters");
		            menu_list[3] = ("(3) set video output parameters");
		            menu_list[4] = ("(4) get trigger parameters");
		            menu_list[5] = ("(5) set trigger parameters");
		            menu_list[6] = ("(6) get encoder parameters");
		            menu_list[7] = ("(7) set encoder parameters");
		            menu_list[8] = ("(8) get IO configuration");
		            menu_list[9] = ("(9) set IO configuration");
		            menu_list[10] = ("(a) get camera operating values"); //
		            menu_list[11] = ("(b) get camera information"); //
		            menu_list[12] = ("(m) Main menu");
		            menu_list[13] = ("(q) Quit program");
                    break;

                case (int)MENUS.COMMAND_MENU5:
                    Array.Resize(ref menu_list, 6);
		            menu_list[0] = ("(0) get led flash settings");
		            menu_list[1] = ("(1) set led flash settings");
                    menu_list[2] = ("(2) Get user data from camera");
                    menu_list[3] = ("(3) Set user data to camera");
		            menu_list[4] = ("(m) Main menu");
		            menu_list[5] = ("(q) Quit program");
                    break;

                case (int)MENUS.COMMAND_DEBUG:
                    Array.Resize(ref menu_list, 9);
		            menu_list[0] = ("(0) Get test pattern setting");
		            menu_list[1] = ("(1) Set test pattern setting");
		            menu_list[2] = ("(2) Get logging parameter");
		            menu_list[3] = ("(3) Set logging parameter");
		            menu_list[4] = ("(4) Get trace mode");
		            menu_list[5] = ("(5) Set trace mode");
                    menu_list[6] = ("(6) Get camera trace messages");
		            menu_list[7] = ("(m) Main menu");
		            menu_list[8] = ("(q) Quit program");
                    break;
                default:
                    break;
            }
            
            int maxItems = menu_list.Length;
            for(int i = 0; i < maxItems; ++i)
            {

                if (!Functions.m_isConnected && i > 1 && i < (maxItems - 1))
                    textattr(Color.DISABLED);
                else
                    textattr(Color.ENABLED);
                
                Console.WriteLine(menu_list[i]);
            }
        }

        //////////////////////////////////////////////////////////////////////////
        /// Handle the commands for the different menus
        //////////////////////////////////////////////////////////////////////////
        public static Int16 menuCommand(int menuNo, int command)
        {
            Int16 nResult = CS_API.CS_OK;
            nResult = CS_API.CS_OK;
            switch (menuNo) 
            {
                case (int)MENUS.START_COMMANDS_MENU:
                    switch (command)
                    {
                        case '0':
                            Functions.connectCamera();
                            if (Functions.isConnected())
                            {
                                nCurrentSetting = Functions.getCurrentSettingNumber();
                            }
                            Console.Clear();
                            displayFunctions(0);
                            break;
                        case '1':
                            Functions.autoDetectCameras();
                            break;
                        case '2':
                            nResult = (int)MENUS.RAW_COMMANDS_MENU;
                            break;
                        case '3':
                            nResult = (int)MENUS.COMMAND_MENU1;
                            break;
                        case '4':
                            nResult = (int)MENUS.COMMAND_MENU2;
                            break;
                        case '5':
                            nResult = (int)MENUS.COMMAND_MENU3;
                            break;
                        case '6':
                            nResult = (int)MENUS.COMMAND_MENU4;
                            break;
                        case '7':
                            nResult = (int)MENUS.COMMAND_MENU5;
                            break;
                        case '8':
                            nResult = (int)MENUS.COMMAND_DEBUG;
                            break;
                    }
                    break;
                case (int)MENUS.RAW_COMMANDS_MENU:
                    switch (command)
                    {
                        case '0':
                            Functions.getBinTag();
                            break;
                        case '1':
                            Functions.setBinTag();
                            break;
                        case '2':
                            Functions.getShortTag();
                            break;
                        case '3':
                            Functions.setShortTag();
                            break;
                        case '4':
                            Functions.getLongTag();
                            break;
                        case '5':
                            Functions.setLongTag();
                            break;
                        case '6':
                            Functions.getVarTag();
                            break;
                        case '7':
                            Functions.setVarTag();
                            break;
                        case '8':
                            Functions.sendHSIFile();
                            break;
                        default:
                            break;
                    }
                    break;

                case (int)MENUS.COMMAND_MENU1:
                    switch (command)
                    {
                        case '0':
            			    Functions.selectSetting();
			                nCurrentSetting = Functions.getCurrentSettingNumber();
                            break;
                        case '1':
                            Functions.showAvailableSettings();
                            break;
                        case '2':
                            Functions.burnSettingsToCamera();
                            break;
                        case '3':
                            Functions.saveCurrentSetting();
                            break;
                        case '4':
                            Functions.getSettingDescription();
                            break;
                        case '5':
                            Functions.setSettingDescription();
                            break;
                        case '6':
                            if (Functions.isConnected())
                            {
                                Console.Write("Resetting camera ......\n");
                                nResult = Functions.resetCamera();
                                nCurrentSetting = Functions.getCurrentSettingNumber();
                                Console.Write("Reset done\n");
                            }
                            break;
                        case '7':
                            Functions.getReferenceSettings();
                            break;
                        case '8':
                            Functions.setReferenceSettings();
                            break;
                        case '9':
                            Functions.prepareCam4Reference();
                            break;
                        case 'a':
                            Console.Clear();
                            Functions.calculateReference();
                            textattr(Color.GREEN);
                            Console.Write("\nPress key to continue");
                            break;
                        case 'b':
                            Functions.createReferenceInternally();
                            break;
                        default:
                            break;
                    }
                    break;

                case (int)MENUS.COMMAND_MENU2:
                    switch (command)
                    {
                        case '0':
                            nResult = Functions.getGainValues();
                            break;
                        case '1':
                            nResult = Functions.setGainValues();
                            break;
                        case '2':
                            nResult = Functions.getInitialGainValues();
                            break;
                        case '3':
                            nResult = Functions.setInitialGainValues();
                            break;
                        case '4':
                            nResult = Functions.getCDSGainValues();
                            break;
                        case '5':
                            nResult = Functions.setCDSGainValues();
                            break;
                        case '6':
                            Functions.getCurrentWhiteReferenceValues();
                            break;
                        case '7':
                            Functions.getCameraWhiteBalancingSetup();
                            textattr(Color.GREEN);
                            Console.Write("\nPress key to continue");
                            _getch();
                            nResult = (int)MENUS.COMMAND_MENU2;
                            break;
                        case '8':
                            Functions.setCameraWhiteBalancingSetup();
                            textattr(Color.GREEN);
                            Console.Write("\nPress key to continue");
                            _getch();
                            nResult = (int)MENUS.COMMAND_MENU2;
                            break;
                        case '9':
                            Functions.checkWhiteBalance();
                            break;
                        case 'a':
                            Functions.doTapBalancing();
                            break;
                        default:
                            break;

                    }
                    break;

                case (int)MENUS.COMMAND_MENU3:
                    switch (command)
                    {
                        case '0':
                            Functions.getImageParameter();
                            break;
                        case '1':
                            Functions.setImageParameter();
                            break;
                        case '2':
                            Functions.getIntegrationTimeSettings();
                            break;
                        case '3':
                            Functions.setIntegrationTimeSettings();
                            break;
                        case '4':
                            Functions.getCamLinkProps();
                            break;
                        case '5':
                            Functions.setCamLinkProps();
                            break;
                        case '6':
                            nResult = Functions.getBrightnessAndContrast();
                            break;
                        case '7':
                            nResult = Functions.setBrightnessAndContrast();
                            break;
                        case '8':
                            Functions.getImageProcessingParameter();
                            break;
                        case '9':
                            Functions.setImageProcessingParameter();
                            break;
                        default:
                            break;
                    }
                    break;

                case (int)MENUS.COMMAND_MENU4:
                    switch (command)
                    {
                        case '0':
                            Functions.getPhysicalSetupParameter();
                            break;
                        case '1':
                            Functions.setPhysicalSetupParameter();
                            break;
                        case '2':
                            Functions.getVideoOutputParameter();
                            break;
                        case '3':
                            Functions.setVideoOutputParameter();
                            break;
                        case '4':
                            Functions.getTriggerSettings();
                            break;
                        case '5':
                            Functions.setTriggerSettings();
                            break;
                        case '6':
                            Functions.getEncoderSettings();
                            break;
                        case '7':
                            Functions.setEncoderSettings();
                            break;
                        case '8':
                            Functions.getIOConfigurationParameter();
                            break;
                        case '9':
                            Functions.setIOConfigurationParameter();
                            break;
                        case 'a':
                            nResult = Functions.get_camera_operating_values();
                            break;
                        case 'b':
                            nResult = Functions.get_camera_information();
                            break;
                        default:
                            break;
                    }
                    break;

                case (int)MENUS.COMMAND_MENU5:
                    switch (command)
                    {
                        case '0':
                            Functions.getLedFlashSettings();
                            break;
                        case '1':
                            Functions.setLedFlashSettings();
                            break;
                        case '2':
                            Functions.getCameraDataFromCameraMemory();
                            break;
                        case '3':
                            Functions.storeDataToCameraMemory();
                            break;
                        default:
                            break;
                    }
                    break;

                case (int)MENUS.COMMAND_DEBUG:
                    switch (command)
                    {
                        case '0':
                            Functions.getTestPatternSettings();
                            break;
                        case '1':
                            Functions.setTestPatternSettings();
                            break;
                        case '2':
                            Functions.getLoggingParameter();
                            break;
                        case '3':
                            Functions.setLoggingParameter();
                            break;
                        case '4':
                            Functions.getTraceMode();
                            break;
                        case '5':
                            Functions.setTraceMode();
                            break;
                        case '6':
                            Console.Clear();
                            Functions.getCameraTrace();
                            Console.Write("\nPress key to continue");
                            nResult = (int)MENUS.COMMAND_DEBUG;
                            _getch();
                            break;
                        default:
                            break;
                    }
                    break;
                default:
                    break;
            }
            return nResult;
        }

        /// ////////////////////////////////////////////////////////////
        /// Main program for the test application
        /// ////////////////////////////////////////////////////////////
        static void Main(string[] args)
        {

            Functions.m_isConnected = false;
            Int16 ini = Functions.InitAPI();     
            int choice = -1;
            bool bRun = true;
            Console.Clear();
            displayFunctions((int) MENUS.START_COMMANDS_MENU);
            while(bRun)
            {
                // Wait for user input
                choice = _getch();
                Console.Clear();
                displayFunctions(currentMenu);
                switch(choice)
                {
                    case 'q':
                    case 'Q':
                        {
                            textattr(Color.RED);
                            Console.Write("\n\nDo you really want to quit (Press 'y' to end the program)?");
                            choice = _getch();
                            if ((choice == 'y') || (choice == 'Y'))
                            {
                                bRun = false;
                            }
                            else
                            {
                                Console.Clear();
                                displayFunctions(currentMenu);
                            }
                        }
                        break;
                    case 'm':
                    case 'M':
                        currentMenu = (int) MENUS.START_COMMANDS_MENU;
                        Console.Clear();
                        displayFunctions(currentMenu);
                        break;
                    default:
                        choice = menuCommand(currentMenu, choice);
                        if ((choice > 0) && choice <= 7)
                        {
                            currentMenu = choice;
                            Console.Clear();
                            displayFunctions(currentMenu);
                        }
                        break;
                }
            }

            // Close the interface
            Functions.closeInterface();
        }
    }
}
