﻿using System;
using CSGenICam.CSI;
using CSGenICam;
using System.Drawing.Imaging;
using System.Drawing;
using System.Runtime.InteropServices;
using System.IO;
class DemoProgram
{
    static unsafe void Main(string[] args)
    {
        var lib = new Library();
        // Use this example to point to a specific GenTL producer file,
        lib.Options.AdditionalSearchPaths.Add(@"C:\Program Files\Chromasens\GCT2\GenTL\s2i");
        lib.Options.UseAdditionSearchPathsOnly = true;

        // Run discovery and check for available devices
        if(lib.Discovery.Cameras.Count > 0) {
            // Use the first device in the list
            var cam = lib.Discovery.Cameras[0];

            // Register for incoming NewImage events
            cam.DataStreams[0].Register((sender, evt) => 
            {
				//System.Console.WriteLine("New image received!" + evt.Data.ImageNr);
				try
				{
					unsafe
					{
						var imageData = evt.Data.EventValue; // pointer to the image image data (sbyte*)
						var imageLength = evt.Data.EventValueSizeBytes;
						var imageInfo = evt.Data.ImageInfo; // image information, like width, height, pixel format                                
						//IntPtr ptr = evt.Data.__Instance;
						//Bitmap bmp = new Bitmap((int)imageInfo.Width, (int)imageInfo.Height, (int)imageInfo.LinePitch, PixelFormat.Format8bppIndexed, ptr);

						//System.Console.WriteLine("New image Format!" + imageInfo.Format);                            
						//WriteLog("New image Format!" + imageInfo.Format, false);
						if (imageInfo.Format == CsiPixelFormat.CSI_PIX_FORMAT_MONO8)
						{
							Bitmap grabBMP;

							grabBMP = new Bitmap((int)imageInfo.Width, (int)imageInfo.Height, PixelFormat.Format8bppIndexed);

							// Set the palette for gray shades
							ColorPalette pal = grabBMP.Palette;

							for (int i = 0; i < pal.Entries.Length; i++)
								pal.Entries[i] = Color.FromArgb(i, i, i);

							grabBMP.Palette = pal;
							BitmapData bmData = grabBMP.LockBits(new System.Drawing.Rectangle(Point.Empty, grabBMP.Size),
																	   ImageLockMode.WriteOnly, grabBMP.PixelFormat);

							IntPtr Iptr = IntPtr.Zero;
							Iptr = bmData.Scan0;

                            System.Console.WriteLine("Image height: " + (int)imageInfo.Height);

                            int value = (int)imageInfo.Width * (int)imageInfo.Height * (int)imageInfo.NumChannels;
							byte[] b = new byte[value];
							Marshal.Copy((IntPtr)imageData, b, 0, value);
							Marshal.Copy(b, 0, Iptr, value);
							var filePath = "sampleImg-" + evt.Data.ImageNr + ".bmp";
							saveImage(ref grabBMP, filePath);
							grabBMP.UnlockBits(bmData);

							System.Console.WriteLine("Saved Image in " + filePath);
						}
					}
				}
				catch (AccessViolationException ave)
				{
					System.Console.WriteLine("Access Violation Error![" + ave.Message.ToString() + "]");
					System.Console.WriteLine("Error StackTrace:" + ave.StackTrace);
				}
				catch (Exception ex)
				{
					System.Console.WriteLine("Error - " + ex.Message);
				}

				// Release data                                
				evt.ReleaseData();
			});

            cam.StartAcquisition();

            // Let acquisition run for 2 seconds and stop afterwards
            System.Threading.Thread.Sleep(2000);
            cam.StopAcquisition();

            // Close camera
            cam.Close();
        }
    }

    public static void LogFunc(CsiLogLevel ll, string message, IntPtr userdata)
    {

    }
	public static void saveImage(ref Bitmap image, string file)
	{
		FileStream imageWrite = new FileStream(file, FileMode.OpenOrCreate, FileAccess.ReadWrite, FileShare.None, 8, FileOptions.None);
		image.Save(imageWrite, System.Drawing.Imaging.ImageFormat.Bmp);
	}
}
