#ifndef SVCAMFEATURE_H
#define SVCAMFEATURE_H

#include <vector>
#include <string>
#include "sv_gen_sdk.h"

typedef struct _SVCamFeatureInfo
{
    int64_t intValue;
    double doubleValue;
    bool booValue;
    char strValue[SV_STRING_SIZE];
    char subFeatureName[SV_STRING_SIZE];

    SV_FEATURE_INFO featurInfo;
    SV_FEATURE_HANDLE hFeature;
    SV_REMOTE_DEVICE_HANDLE hRemoteDevice;
} SVCamFeatureInfo;

class SVCamFeature
{
public:
    SVCamFeature(SV_REMOTE_DEVICE_HANDLE _hRemoteDevice);
    ~SVCamFeature();

    /*
    Clean up the previous feature info list if it exists.
    For each feature create a new Feature structure SVCamFeaturInf and fill it with all information needed to control the camera.
    */
    void getDeviceFeatureList(SV_FEATURE_VISIBILITY visibility);

private:
    /*
    Update Feature Info.
    All feature values will be converted to a string (strValue) to be displayed later in the tree.
    */
    void getFeatureValue(SV_FEATURE_HANDLE hFeature, SVCamFeatureInfo* camFeatureInfo);

    /*
    Register callback to be called when hFeature is invalidated.
    */
    SV_RETURN RegisterInvalidateCB(char*featureName, SV_CB_OBJECT objCb, SV_CB_FEATURE_INVALIDATED_PFN2 pfnFeatureInvalidateCb);

    /*
    Unregister callback function registered on RegisterInvalidateCB.
    The streaming has to be stopped before calling this function.
    */
    SV_RETURN UnRegisterInvalidateCB(SV_FEATURE_HANDLE hFeature);

public:
    void printFeatureList();

private:
    template <class C> void DSDeleteContainer( C & cntr ) {
        for ( typename C::iterator it = cntr.begin();it != cntr.end(); ++it )
        {
            if (*it )
            {
                delete *it;
                *it = NULL;
            }
        }
        cntr.clear();
    }

    template <class C> void DSDeleteContainerReverse( C & cntr ) {
        for (typename C::reverse_iterator rit = cntr.rbegin(); rit != cntr.rend(); ++rit)
        {
            delete *rit;
            *rit = NULL;
        }
        cntr.clear();
    }

    SV_REMOTE_DEVICE_HANDLE m_hRemoteDevice;
    std::vector <SVCamFeatureInfo*> m_featureInfolist;
};
#endif
