#!/bin/bash

# echo "==============================="
# echo "Welcome to Install SVCamKit"
# echo "==============================="

function check() {
	if [ $? == 0 ]; then
		:
	else
		echo "... not ok"
		exit 1
	fi
}

oldpath=$(pwd)

if (($EUID != 0)); then
	pkexec "$oldpath"/SVCam_Kit_Install_Linux.sh "$oldpath"
	check
	cp /opt/SVS/SVCamKit/SVCapture/SVCapture64.desktop ~/Desktop
	check
	chmod +x ~/Desktop/SVCapture64.desktop
	check
	exit
fi

svpath="$1"

echo "Installing ..."

if [ -d /etc/udev/rules.d -a -f "$svpath"/SVCamKit/others/60-svcamkit-u3v.rules ]; then
	cp "$svpath"/SVCamKit/others/60-svcamkit-u3v.rules /etc/udev/rules.d
	check
fi

if [ -d /etc/systemd/system -a -f "$svpath"/SVCamKit/others/svcamkit_u3v_startup.service ]; then
	cp "$svpath"/SVCamKit/others/svcamkit_u3v_startup.service /etc/systemd/system
	check
fi

if [ -d /etc/systemd -a -f "$svpath"/SVCamKit/others/svcamkit_u3v_startup.sh ]; then
	cp "$svpath"/SVCamKit/others/svcamkit_u3v_startup.sh /etc/systemd
	check
fi

if [ -d /etc/sysctl.d -a -f "$svpath"/SVCamKit/others/60-svcamkit-gev.conf ]; then
	cp "$svpath"/SVCamKit/others/60-svcamkit-gev.conf /etc/sysctl.d
	check
fi

if [ -d /usr/share/polkit-1/actions -a -f "$svpath"/SVCamKit/others/com.svsvistek.pkexec.svipconfig.policy ]; then
	cp "$svpath"/SVCamKit/others/com.svsvistek.pkexec.svipconfig.policy /usr/share/polkit-1/actions
	check
fi

mkdir -p /opt/SVS
check
if [ -d /opt/SVS ]; then
	cp -r "$svpath"/SVCamKit/ /opt/SVS/
	check
fi

if [ -d /etc/ld.so.conf.d -a -f "$svpath"/SVCamKit/others/svcamkit.conf ]; then
	cp "$svpath"/SVCamKit/others/svcamkit.conf /etc/ld.so.conf.d
	check
	ldconfig
	check
fi

if [ -f /etc/environment ]; then
	cp /etc/environment /etc/environment_$(date +"%Y%m%d_%H%M%S")
	check
	echo 'SVS_GENICAM_CACHE="/opt/SVS/SVCamKit/SDK/Linux64_x64/cache/"' >>/etc/environment
	echo 'SVS_SDK_BIN_64="/opt/SVS/SVCamKit/SDK/Linux64_x64/"' >>/etc/environment
	echo 'GENICAM_GENTL64_PATH="/opt/SVS/SVCamKit/SDK/Linux64_x64/cti"' >>/etc/environment
	check
fi

cd /opt/SVS/SVCamKit/Utils
chown root:root SVIPConfig-x86_64
chmod 4511 SVIPConfig-x86_64

if [ -d /usr/local/bin ]; then
	cd /usr/local/bin
	if [ ! -L /usr/local/bin/SVCapture64 ]; then
		ln -s /opt/SVS/SVCamKit/SVCapture/SVCapture64
		check
	fi
	if [ ! -L /usr/local/bin/SVIPConfig-x86_64 ]; then
		ln -s /opt/SVS/SVCamKit/Utils/SVIPConfig-x86_64
		check
	fi
fi

if [ -f /etc/systemd/svcamkit_u3v_startup.sh ]; then
	chmod +x /etc/systemd/svcamkit_u3v_startup.sh
	check
	systemctl enable svcamkit_u3v_startup.service
	check
fi

echo "SVCamKit is installed successfully on /opt/SVS/SVCamKit folder!"
echo "Please reboot the pc!"
echo
