////////////////////////////////////////////////////////////////////////////////////////////////////
// Class CXLC4Tcpio
// Implementiert die Methoden zum Senden und Empfangen der XLC-Kommandos
// ber eine TCP/IP-Verbindung TELNET-Verbindung.
// Herstellen der Vebindung:   Open(ipAddr,port)     ist individuell Aufruf ber Men
// Sendne eines Kommandos:     SendCmd( XlcCommand)  berschreibt die gleichnamige virt. Funkt. aus CXlcio 
// Antwort von XLX4 abholen:   GetResponse( XlcResponse) berschreibt die gleichnamige virt. Funkt. aus CXlcio 
///////////////////////////////////////////////////////////////////////////////////////////////////////////


#pragma once

#include "stdafx.h"
#include <stdlib.h>
//#include "afxwin.h"
//#include "afxcmn.h"
#include <winsock2.h>
#include <ws2tcpip.h>
#include <atlstr.h>
#include "xlcio.h"
#include "HresTimer.h"


// Need to link with Ws2_32.lib, Mswsock.lib, and Advapi32.lib
#pragma comment (lib, "Ws2_32.lib")

#define DEFAULT_BUFLEN      512
#define USERNAME_BUFLEN     32
#define PASSWORD_BUFLEN     32

#define DEFAULT_TELNET_USER     "admin"
#define DEFAULT_TELNET_PASSWORD "chromasens"
/*
#define ERR_SUCCESS        (0)
#define ERR_RECV           (-1)
#define ERR_RECVTIMEOUT    (-2)
#define ERR_RECVOVERFLOW   (-3)
#define ERR_XLCOPEN        (-4)
#define ERR_SEND           (-5)
#define ERR_SENDBUFSIZE    (-6)
#define ERR_NOTCONNECTED   (-7)
#define ERR_GETRESPONSE    (-8)
#define ERR_QUITTELNET     (-9)
#define ERR_SENDTIMEOUT    (-10)
#define ERR_WSASHUTDOWN    (-11)
#define ERR_NOSTXFRAME     (-12)
#define ERR_NOIPADDRFOUND  (-13)
#define ERR_COULDNOTLOCATE (-14)
#define ERR_WSASTARTUP       (-15)
#define ERR_CREATESOCKET     (-16)
#define ERR_SETTONONBLOCKING (-17)
#define ERR_SOCKETCONNECT    (-18)
#define ERR_TELNETLOGIN1     (-19)    // von Telnet-chip bei Login gesendete Telegramme
#define ERR_TELNETLOGIN2     (-20)    // abholen
#define ERR_TELNETLOGIN3     (-21)
#define ERR_TELNETLOGINPUSER (-22)    // failed to send user name
#define ERR_TELNETLOGINPW    (-23)    // failed to send user password
#define ERR_NOHIGHRESCOUNTER (-24)    // no high resolution perf. counter to realize timeout control
#define ERR_CONNECTIONCLOSED (-25)    // nach recv Return-Wert = 0
#define ERR_RESPONSEINCOMPLETE (-26)  // kein ETX 0x03 empfangen
#define ERR_CLOSERECV (-27)
*/

typedef enum {
  ERR_SUCCESS            = (0),
  ERR_RECV               = (-4001),
  ERR_RECVTIMEOUT        = (-4002),
  ERR_RECVOVERFLOW       = (-4003),
  ERR_XLCOPEN            = (-4004),
  ERR_SEND               = (-4005),
  ERR_SENDBUFSIZE        = (-4006),
  ERR_NOTCONNECTED       = (-4007),
  ERR_GETRESPONSE        = (-4008),
  ERR_QUITTELNET         = (-4009),
  ERR_SENDTIMEOUT        = (-4010),
  ERR_WSASHUTDOWN        = (-4011),
  ERR_NOSTXFRAME         = (-4012),
  ERR_NOIPADDRFOUND      = (-4013),
  ERR_COULDNOTLOCATE     = (-4014),
  ERR_WSASTARTUP         = (-4015),
  ERR_CREATESOCKET       = (-4016),
  ERR_SETTONONBLOCKING   = (-4017),
  ERR_SOCKETCONNECT      = (-4018),
  ERR_TELNETLOGIN1       = (-4019),    // von Telnet-chip bei Login gesendete Telegramme
  ERR_TELNETLOGIN2       = (-4020),    // abholen
  ERR_TELNETLOGIN3       = (-4021),
  ERR_TELNETLOGINPUSER   = (-4022),    // failed to send user name
  ERR_TELNETLOGINPW      = (-4023),    // failed to send user password
  ERR_NOHIGHRESCOUNTER   = (-4024),    // no high resolution perf. counter to realize timeout control
  ERR_CONNECTIONCLOSED   = (-4025),    // nach recv Return-Wert = 0
  ERR_RESPONSEINCOMPLETE = (-4026),  // kein ETX 0x03 empfangen
  ERR_CLOSERECV          = (-4027)

  } tcpErrNum_t;


// Fehler-Rckgabewerte der Funktionen
// Bei IO-fehlern steht zustzlich das Ergebnis von WSAGetLastError() in der 
// Membervariablen 


class CXLC4Tcpio : 	public CXlcio
{
 public:
   CXLC4Tcpio(void);
   virtual ~CXLC4Tcpio(void);

   int Open( CString xlcNameOrAddr, int PortNum);
   DWORD Close( void );

   int SendCmd( CString strCommand );
   int GetResponse(CString &response);
   BOOL IsOpened( void );

   CString m_strIPv4HostAddr;  // Parameter oder von getHostAddrByName gefunder char[] nach CString
   char m_cXlcIPv4[20];       // IP-Adresse entwerder wie im Men eingeg. oder ber hostname gefunden
   int  m_wsaErrCode;         // bei Fehler-Rckgabe steht hier der Code WSAGetLastError()
   CString m_errMsg;          // Baustelle Fehlerkonzept

protected:
// Socket structures
   WSADATA m_WsaData;
   SOCKET  m_ConnectSocket;
   sockaddr_in m_clientService; 
   BOOL m_bOpened;
   int m_bytesRead;
//
   CHresTimer stopWatch;          // Zeitberwachung mit Highresolution.
   double m_HrCounterResolution;  // Perormance Counter
   double m_nulltime;
//
   int  m_recvbuflen;
   char sendbuf[DEFAULT_BUFLEN];
   char recvbuf[DEFAULT_BUFLEN];
   char m_telnetUser[USERNAME_BUFLEN+2];
   char m_telnetPassword[PASSWORD_BUFLEN+2];
//
   int CXLC4Tcpio::sendXlcData( char *pBuffer, const int nBufLen, int &bytesToSend, unsigned int nTimeout);
   int CXLC4Tcpio::receiveXlcData( char *pBuffer, const int nBufLen, int &bytesRead, unsigned int nTimeout);
};

//
//  definiere eine Error-Klasse
//
class CXLC4TcpIoError {
public:
	CXLC4TcpIoError(tcpErrNum_t xlcErr, int wsaErr, CString msg);
	tcpErrNum_t xclError;      // Error number of programm situation ERR_...
	int wsaErrorCode;  // Windows Socket API errors
	CString ioErrMsg;
};