// XLC_IP_Demo.cpp : Console application.
// -------------------------------------------------------------------------
// XLC_IP_Demo shows how to communicate with XLC4-1 illumination device
// via a telnet session on a fixed IPv4 Address.
// Author: Hans Dihlmann						Chromasens GmbH
// Erstellt: 2012-12-03
// -------------------------------------------------------------------------
// Vers. 1.0.1 2012-12-05 Show socket error code when connect failed.

#include "stdafx.h"
#include <atlstr.h>
#include "HresTimer.h"
#include "Xlcio.h"
#include "XLC4Tcpio.h"


int _tmain(int argc, _TCHAR* argv[])
{
    char szIPv4Addr[20];
	int iResult;
	DWORD dwResult;
    CXLC4Tcpio myXlc;
	int PortNum;
	size_t len;

    CString VR("VR");     // define some commands
	CString IF("IF");
	CString xlcResponse;  // here the response will be deposited

	std::cout << "Program: XLC4_IP_Demo                             Vers. 1.0.1" << endl;
	std::cout << "-------------------------------------------------------------" << endl;
	std::cout << "This program demonstrates how to communicate with the XLC4" << endl;
	std::cout << "over a given IPv4 address and the port number 23 (telnet)" << endl;
	std::cout << "Enter an IPv4 Address (default 192.168.87.234): ";
    cin.getline(szIPv4Addr,20);
	len = strlen(szIPv4Addr);
	if( len == 0) {
	    strcpy_s(szIPv4Addr,20, "192.168.87.234"); // default address
	}
	std::cout << ">> Trying to open a connection on Address:" << szIPv4Addr << endl;
//
	PortNum = 23;   // telnet
//
//   To begin a session the XLC4 call the open method
//
	CString strIP4Address(szIPv4Addr);
	iResult = myXlc.Open( strIP4Address, PortNum);
	if(iResult != ERR_SUCCESS) {
	   cout << "++ Sorry, unable to connect to XLC4 device" << endl;
	   CW2A printableMsg(myXlc.m_errMsg);
	   cout << printableMsg << endl;
	   system("pause");
	   return 0;
	}
    cout << ">> Connection to XLC4 device opened successfully" << endl;
//
// sendCmd an GetResponse might throw an exception
//
	cout << ">> Sending: VR command,  Request Firmware Version" << endl;
	try {
      myXlc.SendCmd( VR );
      myXlc.GetResponse(xlcResponse);
	}
	 catch(CXLC4TcpIoError xlcErr) {
		cout << "   Exception: IO-error on sending \"Request Firmware Version\"" << endl; 
		cout << xlcErr.ioErrMsg << endl;
	}
    CW2A szVrResponse(xlcResponse);
    cout << ">> Response on firmware request is \"" << szVrResponse << "\"" <<endl;
//
	cout << ">> Sending: IF command,  Request Hardware Info" << endl;
	try {
      myXlc.SendCmd( IF );
      myXlc.GetResponse(xlcResponse);
	}
	 catch(CXLC4TcpIoError xlcErr) {
		cout << "   Exception: IO-error on sending \"Hardware Info Request\"" << endl; 
		cout << xlcErr.ioErrMsg << endl;
	}
    CW2A szIfResponse(xlcResponse);
    cout << ">> Response on Hardware Info Request is  \"" << szIfResponse << "\"" << endl;
//
	char szXlcCommand[100];
	while(TRUE)
	{
	  std::cout << "Enter a command or return only for quit: ";
	  cin.getline(szXlcCommand,100);
	  size_t len = strlen(szXlcCommand);
	  if( len == 0)
		  break;
	  //
	  cout << ">> Sending: " << szXlcCommand << " command" << endl;
	  try {
        myXlc.SendCmd( CString(szXlcCommand));
        myXlc.GetResponse(xlcResponse);
	  }
	  catch(CXLC4TcpIoError xlcErr) {
		cout << "   Exception: IO-error on sending \"Hardware Info Request\"" << endl; 
		cout << xlcErr.ioErrMsg << endl;
	  }
      CW2A szIfResponse(xlcResponse);
      cout << ">> Response on Hardware Info Request is  \"" << szIfResponse << "\"" << endl;
	}

//
//  Closing the connection
//
    dwResult = myXlc.Close();
	if(dwResult != ERR_SUCCESS) {
	   cout << "++ Sorry, unable to close connection to XLC4 device" << endl;
	   cout << "   Error code: " << dwResult << endl;
	   system("pause");
	   return 0;
	}
	cout << ">> Bye, connection to XLC4 device closed sucessfully" << endl;
    system("pause");  
	return 0;
}

